﻿---
title: APM Node.js agent
description: The Elastic APM Node.js Agent sends performance metrics and errors to the APM Server. It has built-in support for the most popular frameworks and routers,...
url: https://www.elastic.co/docs/reference/apm/agents/nodejs
products:
  - APM Agent
  - APM Node.js Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Node.js: Generally available
---

# APM Node.js agent
The Elastic APM Node.js Agent sends performance metrics and errors to the APM Server. It has built-in support for the most popular frameworks and routers, as well as a simple API which allows you to instrument any application.

## How does the Agent work?

The agent auto-instruments [supported frameworks](/docs/reference/apm/agents/nodejs/supported-technologies#compatibility-frameworks) and records interesting events, like HTTP requests and database queries. To do this, it patches modules as they are loaded to capture when module functions and callbacks are called. Additionally, there are some cases where a module will be patched to allow tracing context to be propagated through the asynchronous continuation. This means that for the supported technologies, there are no code changes required.
The Agent automatically links module function calls to callback calls to measure their duration and metadata (like the DB statement), as well as HTTP related information (like the URL, parameters, and headers).
These events, called Transactions and Spans, are sent to the APM Server. The APM Server converts them to a format suitable for Elasticsearch, and sends them to an Elasticsearch cluster. You can then use the APM app in Kibana to gain insight into latency issues and error culprits within your application.

## Additional Components

APM Agents work in conjunction with the [APM Server](https://www.elastic.co/docs/solutions/observability/apm), [Elasticsearch](https://www.elastic.co/docs/get-started), and [Kibana](https://www.elastic.co/docs/get-started/the-stack). The [APM Guide](https://www.elastic.co/docs/solutions/observability/apm) provides details on how these components work together, and provides a matrix outlining [Agent and Server compatibility](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility).

## Troubleshooting

If you're experiencing issues with the APM Node.js agent, refer to [Troubleshoot APM Node.js Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-nodejs/apm-nodejs-agent).