﻿---
title: Upgrading
description: Upgrades between minor versions of the agent, like from 1.1 to 1.2 are always backwards compatible. Upgrades that involve a major version bump often come...
url: https://www.elastic.co/docs/reference/apm/agents/java/upgrading
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# Upgrading
Upgrades between minor versions of the agent, like from 1.1 to 1.2 are always backwards compatible. Upgrades that involve a major version bump often come with some backwards incompatible changes.
Before upgrading the agent, be sure to review the:
- [Agent release notes](https://www.elastic.co/docs/release-notes/apm/agents/java)
- [Agent and Server compatibility chart](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility)


## Recommended upgrade steps

1. Shut down the application.
2. Download the latest release of the agent jar file from [maven central](https://mvnrepository.com/artifact/co.elastic.apm/elastic-apm-agent/latest).
3. Optionally change JVM settings, e.g., if the path to the agent jar has changed due to a different file name.
4. Restart the application.


## End of life dates

We love all our products, but sometimes we must say goodbye to a release so that we can continue moving forward on future development and innovation. Our [End of life policy](https://www.elastic.co/support/eol) defines how long a given release is considered supported, as well as how long a release is considered still in active development or maintenance.