﻿---
title: Tracing APIs
description: There are three different ways enhance the out-of-the-box instrumentation of the Java agent with manual instrumentation: Public API A simple and stable...
url: https://www.elastic.co/docs/reference/apm/agents/java/tracing-apis
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# Tracing APIs
There are three different ways enhance the out-of-the-box instrumentation of the Java agent with manual instrumentation:
1. [Public API](https://www.elastic.co/docs/reference/apm/agents/java/public-api) A simple and stable API that is most native to the agent. Contains annotations to declaratively create spans.
2. [OpenTelemetry bridge](https://www.elastic.co/docs/reference/apm/agents/java/opentelemetry-bridge) A vendor neutral API. If you plan to do a lot of manual instrumentation and want to reduce vendor lock-in this is probably what you’re looking for.
3. [OpenTracing bridge](https://www.elastic.co/docs/reference/apm/agents/java/opentracing-bridge) A vendor neutral API that is discontinued in favor of OpenTelemetry.

A further option is the [plugin api](https://www.elastic.co/docs/reference/apm/agents/java/plugin-api) which uses the OpenTelemetry API and allows you to add in custom instrumentation without modifying the application.

## Operation Modes

All APIs allow for different operation modes in combination with the Elastic APM agent
<definitions>
  <definition term="Noop">
    If the agent is not installed, the APIs are in noop mode and do not actually record and report spans.
  </definition>
  <definition term="Mix and Match">
    If you want to leverage the auto instrumentation of Elastic APM, but also want to create custom spans or use the API to add custom labels to the spans created by Elastic APM, you can just do that.
  </definition>
  <definition term="Manual instrumentation">
    If you don’t want Elastic APM to auto-instrument known frameworks, but instead only rely on manual instrumentation, disable the auto instrumentation setting the configuration option [`instrument`](/docs/reference/apm/agents/java/config-core#config-instrument) to `false`.
  </definition>
</definitions>