﻿---
title: Configuration-based
description: Use the trace_methods configuration option to specify additional methods to instrument. You can match methods via wildcards in the package, class or method...
url: https://www.elastic.co/docs/reference/apm/agents/java/method-config-based
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# Configuration-based
Use the [`trace_methods`](/docs/reference/apm/agents/java/config-core#config-trace-methods) configuration option to specify additional methods to instrument. You can match methods via wildcards in the package, class or method name, by their modifier (like public), by a particular annotation, and more. Because you don’t need to modify your source code, this makes it possible to monitor code in 3rd party libraries.
Be careful, it’s easy to overuse `trace_methods` by matching too many methods— hurting both runtime and startup performance. Use in conjunction with [`span_min_duration`](/docs/reference/apm/agents/java/config-core#config-span-min-duration) when setting for entire packages in order to avoid having too many spans in the APM app.
For more information, and examples, see the [`trace_methods`](/docs/reference/apm/agents/java/config-core#config-trace-methods) configuration reference.