﻿---
title: Annotations
description: The annotation API allows you to place annotations on top of methods to automatically create spans for them. This method of creating spans is easier,...
url: https://www.elastic.co/docs/reference/apm/agents/java/method-annotations
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# Annotations
The [annotation API](/docs/reference/apm/agents/java/public-api#api-annotation) allows you to place annotations on top of methods to automatically create spans for them. This method of creating spans is easier, more robust, and typically more performant than using the API; there’s nothing you can do wrong like forgetting to end a span or close a scope.
Annotations are less flexible when used on their own, but can be combined with the span API for added flexibility.

## How-to create spans with the annotations API

Here’s an example that uses the [`@CaptureSpan`](/docs/reference/apm/agents/java/public-api#api-capture-span) annotation to create a span for the `spanWithAnnotation()` method. The span is named `spanName`, is of type `ext`, and subtype `http`.
```java
@CaptureSpan(value = "spanName", type = "ext", subtype = "http")
private static void spanWithAnnotation() {
    // do your thing...
}
```


## Combine with the span API

You can combine annotations with the span API to increase their flexibility. Just get the current span on an annotated method and customize the span to your liking.
```java
@CaptureSpan 
private static void spanWithAnnotation(String foo) {
    Span span = ElasticApm.currentSpan(); 
    span.setTag("foo", foo); 
}
```