﻿---
title: How to find slow methods
description: Identifying a problematic service is only half of the battle when diagnosing application slowdowns. Luckily, the Elastic APM Java Agent provides multiple...
url: https://www.elastic.co/docs/reference/apm/agents/java/how-to-find-slow-methods
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# How to find slow methods
Identifying a problematic service is only half of the battle when diagnosing application slowdowns. Luckily, the Elastic APM Java Agent provides multiple ways to get method-level insights into your code. This can help you diagnose slow requests due to heavy computations, inefficient algorithms, or similar problems not related to interactions between services.

## If you don’t know which methods you want to monitor…


### Sampling-based profiler

Find out which part of your code is making your application slow by periodically recording running methods with a sampling-based profiler.
![green check](https://www.elastic.co/docs/reference/apm/agents/java/images/green-check.svg) Very low overhead. ![green check](https://www.elastic.co/docs/reference/apm/agents/java/images/green-check.svg) No code changes required. ![red x](https://www.elastic.co/docs/reference/apm/agents/java/images/red-x.svg) Does not work on Windows and on OpenJ9. ![red x](https://www.elastic.co/docs/reference/apm/agents/java/images/red-x.svg) The duration of profiler-inferred spans are not exact measurements, only estimates.
[Learn more](https://www.elastic.co/docs/reference/apm/agents/java/method-sampling-based)

## If you know which methods you want to monitor…


### API/Code

Use the API or OpenTracing bridge to manually create spans for methods of interest.
![green check](https://www.elastic.co/docs/reference/apm/agents/java/images/green-check.svg) Most flexible. ![red x](https://www.elastic.co/docs/reference/apm/agents/java/images/red-x.svg) Incorrect API usage may lead to invalid traces (scope leaks).
[Learn more](https://www.elastic.co/docs/reference/apm/agents/java/method-api)

### Annotations

Annotations can be placed on top of methods to automatically create spans for them.
![green check](https://www.elastic.co/docs/reference/apm/agents/java/images/green-check.svg) Easier and more robust than the API. ![red x](https://www.elastic.co/docs/reference/apm/agents/java/images/red-x.svg) Less flexible on its own, but can be combined with the API.
[Learn more](https://www.elastic.co/docs/reference/apm/agents/java/method-annotations)

### Configuration-based

Use a configuration option to specify additional methods to instrument.
![green check](https://www.elastic.co/docs/reference/apm/agents/java/images/green-check.svg) No need to modify source code. ![green check](https://www.elastic.co/docs/reference/apm/agents/java/images/green-check.svg) Possible to monitor code in third-party libraries. ![green check](https://www.elastic.co/docs/reference/apm/agents/java/images/green-check.svg) Match methods via wildcards. ![red x](https://www.elastic.co/docs/reference/apm/agents/java/images/red-x.svg) Easy to overuse which hurts runtime and startup performance.
[Learn more](https://www.elastic.co/docs/reference/apm/agents/java/method-config-based)