﻿---
title: Configuration
description: To adapt the Elastic APM Java agent to your needs, you can configure it using one of the methods below, listed in descending order of precedence: Arguments...
url: https://www.elastic.co/docs/reference/apm/agents/java/configuration
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# Configuration
To adapt the Elastic APM Java agent to your needs, you can configure it using one of the methods below, listed in descending order of precedence:
1. <definitions>
   <definition term="Central configuration">
   Configure the Agent in the Kibana APM app. [![dynamic config](https://www.elastic.co/docs/reference/apm/agents/java/images/dynamic-config.svg) ](#configuration-dynamic)
   </definition>
   </definitions>
2. <definitions>
   <definition term="Properties file">
   The `elasticapm.properties` file is located in the same folder as the agent jar, or provided through the [`config_file`](/docs/reference/apm/agents/java/config-core#config-config-file) option. ![dynamic config](https://www.elastic.co/docs/reference/apm/agents/java/images/dynamic-config.svg)
   </definition>
   </definitions>
3. <definitions>
   <definition term="Java system properties">
   All configuration keys are prefixed with `elastic.apm.` ![dynamic config](https://www.elastic.co/docs/reference/apm/agents/java/images/dynamic-config.svg)
   </definition>
   </definitions>
4. <definitions>
   <definition term="Environment variables">
   All configuration keys are in uppercase and prefixed with `ELASTIC_APM_`.
   </definition>
   </definitions>
5. <definitions>
   <definition term="Runtime attach parameters">
   1. `--config` parameter. See [Automatic setup with `apm-agent-attach-cli.jar`](https://www.elastic.co/docs/reference/apm/agents/java/setup-attach-cli).
   </definition>
   </definitions>

1. Arguments of `ElasticApmAttacher.attach(...)`. See [Programmatic API setup to self-attach](https://www.elastic.co/docs/reference/apm/agents/java/setup-attach-api).
2. `elasticapm.properties` in classpath root with `ElasticApmAttacher.attach()`. See [Programmatic API setup to self-attach](https://www.elastic.co/docs/reference/apm/agents/java/setup-attach-api).

1. <definitions>
   <definition term="Default values">
   Defined for each configuration.
   </definition>
   </definitions>


## Dynamic configuration ![dynamic config](https://www.elastic.co/docs/reference/apm/agents/java/images/dynamic-config.svg)

Configuration options marked with Dynamic true can be changed at runtime when set from supported sources:
- [Central configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/central-configuration)
- `elasticapm.properties` file
- Java system properties, but only when set from within the application

<note>
  There are two distinct ways to use `elasticapm.properties`: as an external configuration file, and as a classpath resource. Only the external file can be used for dynamic configuration.
</note>


## Minimal configuration

In order to get started with Elastic APM, the most important configuration options are [`service_name`](/docs/reference/apm/agents/java/config-core#config-service-name), [`server_url`](/docs/reference/apm/agents/java/config-reporter#config-server-url) and [`application_packages`](/docs/reference/apm/agents/java/config-stacktrace#config-application-packages). Note that even these settings are optional. Click on their name to see how the default values are determined.
An example configuration looks like this:
```bash
-Delastic.apm.service_name=my-cool-service
-Delastic.apm.application_packages=org.example,org.another.example
-Delastic.apm.server_url=http://127.0.0.1:8200
```

```properties
service_name=my-cool-service
application_packages=org.example,org.another.example
server_url=http://127.0.0.1:8200
```

```bash
ELASTIC_APM_SERVICE_NAME=my-cool-service
ELASTIC_APM_APPLICATION_PACKAGES=org.example,org.another.example
ELASTIC_APM_SERVER_URL=http://127.0.0.1:8200
```


## Option reference

This is a list of all configuration options grouped by their category. Click on a key to get more information.
- [Circuit-Breaker](https://www.elastic.co/docs/reference/apm/agents/java/config-circuit-breaker)
  - [`circuit_breaker_enabled` ([1.14.0] performance)](/docs/reference/apm/agents/java/config-circuit-breaker#config-circuit-breaker-enabled)
- [`stress_monitoring_interval` (performance)](/docs/reference/apm/agents/java/config-circuit-breaker#config-stress-monitoring-interval)
- [`stress_monitor_gc_stress_threshold` (performance)](/docs/reference/apm/agents/java/config-circuit-breaker#config-stress-monitor-gc-stress-threshold)
- [`stress_monitor_gc_relief_threshold` (performance)](/docs/reference/apm/agents/java/config-circuit-breaker#config-stress-monitor-gc-relief-threshold)
- [`stress_monitor_cpu_duration_threshold` (performance)](/docs/reference/apm/agents/java/config-circuit-breaker#config-stress-monitor-cpu-duration-threshold)
- [`stress_monitor_system_cpu_stress_threshold` (performance)](/docs/reference/apm/agents/java/config-circuit-breaker#config-stress-monitor-system-cpu-stress-threshold)
- [`stress_monitor_system_cpu_relief_threshold` (performance)](/docs/reference/apm/agents/java/config-circuit-breaker#config-stress-monitor-system-cpu-relief-threshold)
- [Core](https://www.elastic.co/docs/reference/apm/agents/java/config-core)
  - [`recording` ([1.15.0])](/docs/reference/apm/agents/java/config-core#config-recording)
- [`enabled` ([1.18.0])](/docs/reference/apm/agents/java/config-core#config-enabled)
- [`instrument` ([1.0.0])](/docs/reference/apm/agents/java/config-core#config-instrument)
- [`service_name`](/docs/reference/apm/agents/java/config-core#config-service-name)
- [`service_node_name` ([1.11.0])](/docs/reference/apm/agents/java/config-core#config-service-node-name)
- [`service_version`](/docs/reference/apm/agents/java/config-core#config-service-version)
- [`hostname` ([1.10.0])](/docs/reference/apm/agents/java/config-core#config-hostname)
- [`environment`](/docs/reference/apm/agents/java/config-core#config-environment)
- [`transaction_sample_rate` (performance)](/docs/reference/apm/agents/java/config-core#config-transaction-sample-rate)
- [`transaction_max_spans` (performance)](/docs/reference/apm/agents/java/config-core#config-transaction-max-spans)
- [`long_field_max_length` (performance [1.37.0])](/docs/reference/apm/agents/java/config-core#config-long-field-max-length)
- [`sanitize_field_names` (security)](/docs/reference/apm/agents/java/config-core#config-sanitize-field-names)
- [`enable_instrumentations` ([1.28.0])](/docs/reference/apm/agents/java/config-core#config-enable-instrumentations)
- [`disable_instrumentations` ([1.0.0])](/docs/reference/apm/agents/java/config-core#config-disable-instrumentations)
- [`enable_experimental_instrumentations` ([1.25.0])](/docs/reference/apm/agents/java/config-core#config-enable-experimental-instrumentations)
- [`unnest_exceptions`](/docs/reference/apm/agents/java/config-core#config-unnest-exceptions)
- [`ignore_exceptions` ([1.11.0])](/docs/reference/apm/agents/java/config-core#config-ignore-exceptions)
- [`capture_body` (performance)](/docs/reference/apm/agents/java/config-core#config-capture-body)
- [`capture_headers` (performance)](/docs/reference/apm/agents/java/config-core#config-capture-headers)
- [`global_labels` ([1.7.0])](/docs/reference/apm/agents/java/config-core#config-global-labels)
- [`instrument_ancient_bytecode` ([1.35.0])](/docs/reference/apm/agents/java/config-core#config-instrument-ancient-bytecode)
- [`context_propagation_only` ([1.44.0])](/docs/reference/apm/agents/java/config-core#config-context-propagation-only)
- [`classes_excluded_from_instrumentation`](/docs/reference/apm/agents/java/config-core#config-classes-excluded-from-instrumentation)
- [`trace_methods` ([1.0.0])](/docs/reference/apm/agents/java/config-core#config-trace-methods)
- [`trace_methods_duration_threshold` ([1.7.0])](/docs/reference/apm/agents/java/config-core#config-trace-methods-duration-threshold)
- [`central_config` ([1.8.0])](/docs/reference/apm/agents/java/config-core#config-central-config)
- [`breakdown_metrics` ([1.8.0])](/docs/reference/apm/agents/java/config-core#config-breakdown-metrics)
- [`config_file` ([1.8.0])](/docs/reference/apm/agents/java/config-core#config-config-file)
- [`plugins_dir` (experimental)](/docs/reference/apm/agents/java/config-core#config-plugins-dir)
- [`use_elastic_traceparent_header` ([1.14.0])](/docs/reference/apm/agents/java/config-core#config-use-elastic-traceparent-header)
- [`disable_outgoing_tracecontext_headers` ([1.37.0])](/docs/reference/apm/agents/java/config-core#config-disable-outgoing-tracecontext-headers)
- [`span_min_duration` ([1.16.0])](/docs/reference/apm/agents/java/config-core#config-span-min-duration)
- [`cloud_provider` ([1.21.0])](/docs/reference/apm/agents/java/config-core#config-cloud-provider)
- [`enable_public_api_annotation_inheritance` (performance)](/docs/reference/apm/agents/java/config-core#config-enable-public-api-annotation-inheritance)
- [`transaction_name_groups` ([1.33.0])](/docs/reference/apm/agents/java/config-core#config-transaction-name-groups)
- [`trace_continuation_strategy` ([1.34.0])](/docs/reference/apm/agents/java/config-core#config-trace-continuation-strategy)
- [`baggage_to_attach` ([1.43.0])](/docs/reference/apm/agents/java/config-core#config-baggage-to-attach)
- [Datastore](https://www.elastic.co/docs/reference/apm/agents/java/config-datastore)
  - [`elasticsearch_capture_body_urls` ([1.37.0])](/docs/reference/apm/agents/java/config-datastore#config-elasticsearch-capture-body-urls)
- [`mongodb_capture_statement_commands`](/docs/reference/apm/agents/java/config-datastore#config-mongodb-capture-statement-commands)
- [HTTP](https://www.elastic.co/docs/reference/apm/agents/java/config-http)
  - [`capture_body_content_types` ([1.5.0] performance)](/docs/reference/apm/agents/java/config-http#config-capture-body-content-types)
- [`transaction_ignore_urls`](/docs/reference/apm/agents/java/config-http#config-transaction-ignore-urls)
- [`transaction_ignore_user_agents` ([1.22.0])](/docs/reference/apm/agents/java/config-http#config-transaction-ignore-user-agents)
- [`use_path_as_transaction_name` ([1.0.0])](/docs/reference/apm/agents/java/config-http#config-use-path-as-transaction-name)
- [`url_groups` (deprecated)](/docs/reference/apm/agents/java/config-http#config-url-groups)
- [`capture_http_client_request_body_size` ([1.52.0] experimental)](/docs/reference/apm/agents/java/config-http#config-capture-http-client-request-body-size)
- [`capture_http_client_request_body_as_label` ([1.54.0] experimental)](/docs/reference/apm/agents/java/config-http#config-capture-http-client-request-body-as-label)
- [Huge Traces](https://www.elastic.co/docs/reference/apm/agents/java/config-huge-traces)
  - [`span_compression_enabled` ([1.30.0])](/docs/reference/apm/agents/java/config-huge-traces#config-span-compression-enabled)
- [`span_compression_exact_match_max_duration` ([1.30.0])](/docs/reference/apm/agents/java/config-huge-traces#config-span-compression-exact-match-max-duration)
- [`span_compression_same_kind_max_duration` ([1.30.0])](/docs/reference/apm/agents/java/config-huge-traces#config-span-compression-same-kind-max-duration)
- [`exit_span_min_duration` ([1.30.0])](/docs/reference/apm/agents/java/config-huge-traces#config-exit-span-min-duration)
- [JAX-RS](https://www.elastic.co/docs/reference/apm/agents/java/config-jax-rs)
  - [`enable_jaxrs_annotation_inheritance` (performance)](/docs/reference/apm/agents/java/config-jax-rs#config-enable-jaxrs-annotation-inheritance)
- [`use_jaxrs_path_as_transaction_name` ([1.8.0])](/docs/reference/apm/agents/java/config-jax-rs#config-use-jaxrs-path-as-transaction-name)
- [JMX](https://www.elastic.co/docs/reference/apm/agents/java/config-jmx)
  - [`capture_jmx_metrics` ([1.11.0])](/docs/reference/apm/agents/java/config-jmx#config-capture-jmx-metrics)
- [Logging](https://www.elastic.co/docs/reference/apm/agents/java/config-logging)
  - [`log_level`](/docs/reference/apm/agents/java/config-logging#config-log-level)
- [`log_file`](/docs/reference/apm/agents/java/config-logging#config-log-file)
- [`log_ecs_reformatting` ([1.22.0] experimental)](/docs/reference/apm/agents/java/config-logging#config-log-ecs-reformatting)
- [`log_ecs_reformatting_additional_fields` ([1.26.0])](/docs/reference/apm/agents/java/config-logging#config-log-ecs-reformatting-additional-fields)
- [`log_ecs_formatter_allow_list`](/docs/reference/apm/agents/java/config-logging#config-log-ecs-formatter-allow-list)
- [`log_ecs_reformatting_dir`](/docs/reference/apm/agents/java/config-logging#config-log-ecs-reformatting-dir)
- [`log_file_size` ([1.17.0])](/docs/reference/apm/agents/java/config-logging#config-log-file-size)
- [`log_format_sout` ([1.17.0])](/docs/reference/apm/agents/java/config-logging#config-log-format-sout)
- [`log_format_file` ([1.17.0])](/docs/reference/apm/agents/java/config-logging#config-log-format-file)
- [`log_sending` ([1.36.0] experimental)](/docs/reference/apm/agents/java/config-logging#config-log-sending)
- [Messaging](https://www.elastic.co/docs/reference/apm/agents/java/config-messaging)
  - [`ignore_message_queues`](/docs/reference/apm/agents/java/config-messaging#config-ignore-message-queues)
- [`jms_listener_packages` (performance [1.36.0])](/docs/reference/apm/agents/java/config-messaging#config-jms-listener-packages)
- [`rabbitmq_naming_mode` ([1.46.0])](/docs/reference/apm/agents/java/config-messaging#config-rabbitmq-naming-mode)
- [Metrics](https://www.elastic.co/docs/reference/apm/agents/java/config-metrics)
  - [`dedot_custom_metrics` ([1.22.0])](/docs/reference/apm/agents/java/config-metrics#config-dedot-custom-metrics)
- [`custom_metrics_histogram_boundaries` ([1.37.0] experimental)](/docs/reference/apm/agents/java/config-metrics#config-custom-metrics-histogram-boundaries)
- [`metric_set_limit` ([1.33.0])](/docs/reference/apm/agents/java/config-metrics#config-metric-set-limit)
- [`agent_reporter_health_metrics` ([1.35.0])](/docs/reference/apm/agents/java/config-metrics#config-agent-reporter-health-metrics)
- [`agent_background_overhead_metrics` ([1.35.0])](/docs/reference/apm/agents/java/config-metrics#config-agent-background-overhead-metrics)
- [Profiling](https://www.elastic.co/docs/reference/apm/agents/java/config-profiling)
  - [`universal_profiling_integration_enabled` ([1.50.0])](/docs/reference/apm/agents/java/config-profiling#config-universal-profiling-integration-enabled)
- [`universal_profiling_integration_buffer_size` ([1.50.0])](/docs/reference/apm/agents/java/config-profiling#config-universal-profiling-integration-buffer-size)
- [`universal_profiling_integration_socket_dir` ([1.50.0])](/docs/reference/apm/agents/java/config-profiling#config-universal-profiling-integration-socket-dir)
- [`profiling_inferred_spans_enabled` ([1.15.0] experimental)](/docs/reference/apm/agents/java/config-profiling#config-profiling-inferred-spans-enabled)
- [`profiling_inferred_spans_logging_enabled` ([1.37.0])](/docs/reference/apm/agents/java/config-profiling#config-profiling-inferred-spans-logging-enabled)
- [`profiling_inferred_spans_sampling_interval` ([1.15.0])](/docs/reference/apm/agents/java/config-profiling#config-profiling-inferred-spans-sampling-interval)
- [`profiling_inferred_spans_min_duration` ([1.15.0])](/docs/reference/apm/agents/java/config-profiling#config-profiling-inferred-spans-min-duration)
- [`profiling_inferred_spans_included_classes` ([1.15.0])](/docs/reference/apm/agents/java/config-profiling#config-profiling-inferred-spans-included-classes)
- [`profiling_inferred_spans_excluded_classes` ([1.15.0])](/docs/reference/apm/agents/java/config-profiling#config-profiling-inferred-spans-excluded-classes)
- [`profiling_inferred_spans_lib_directory` ([1.18.0])](/docs/reference/apm/agents/java/config-profiling#config-profiling-inferred-spans-lib-directory)
- [Reporter](https://www.elastic.co/docs/reference/apm/agents/java/config-reporter)
  - [`secret_token`](/docs/reference/apm/agents/java/config-reporter#config-secret-token)
- [`api_key`](/docs/reference/apm/agents/java/config-reporter#config-api-key)
- [`server_url`](/docs/reference/apm/agents/java/config-reporter#config-server-url)
- [`server_urls`](/docs/reference/apm/agents/java/config-reporter#config-server-urls)
- [`disable_send`](/docs/reference/apm/agents/java/config-reporter#config-disable-send)
- [`server_timeout`](/docs/reference/apm/agents/java/config-reporter#config-server-timeout)
- [`verify_server_cert`](/docs/reference/apm/agents/java/config-reporter#config-verify-server-cert)
- [`max_queue_size`](/docs/reference/apm/agents/java/config-reporter#config-max-queue-size)
- [`include_process_args`](/docs/reference/apm/agents/java/config-reporter#config-include-process-args)
- [`api_request_time`](/docs/reference/apm/agents/java/config-reporter#config-api-request-time)
- [`api_request_size`](/docs/reference/apm/agents/java/config-reporter#config-api-request-size)
- [`metrics_interval` ([1.3.0])](/docs/reference/apm/agents/java/config-reporter#config-metrics-interval)
- [`disable_metrics` ([1.3.0])](/docs/reference/apm/agents/java/config-reporter#config-disable-metrics)
- [Serverless](https://www.elastic.co/docs/reference/apm/agents/java/config-serverless)
  - [`aws_lambda_handler` ([1.28.0])](/docs/reference/apm/agents/java/config-serverless#config-aws-lambda-handler)
- [`data_flush_timeout` ([1.28.0])](/docs/reference/apm/agents/java/config-serverless#config-data-flush-timeout)
- [Stacktrace](https://www.elastic.co/docs/reference/apm/agents/java/config-stacktrace)
  - [`application_packages`](/docs/reference/apm/agents/java/config-stacktrace#config-application-packages)
- [`stack_trace_limit` (performance)](/docs/reference/apm/agents/java/config-stacktrace#config-stack-trace-limit)
- [`span_stack_trace_min_duration` (performance)](/docs/reference/apm/agents/java/config-stacktrace#config-span-stack-trace-min-duration)