﻿---
title: Serverless configuration options
description: This config option must be used when running the agent in an AWS Lambda context. This config value allows to specify the fully qualified name of the class...
url: https://www.elastic.co/docs/reference/apm/agents/java/config-serverless
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# Serverless configuration options
## `aws_lambda_handler`

<applies-to>
  - Application Performance Monitoring Agent for Java: Generally available since 1.28
</applies-to>

This config option must be used when running the agent in an AWS Lambda context. This config value allows to specify the fully qualified name of the class handling the lambda function. An empty value (default value) indicates that the agent is not running within an AWS lambda function.

| Default  | Type   | Dynamic |
|----------|--------|---------|
| `<none>` | String | false   |


| Java System Properties           | Property file        | Environment                      |
|----------------------------------|----------------------|----------------------------------|
| `elastic.apm.aws_lambda_handler` | `aws_lambda_handler` | `ELASTIC_APM_AWS_LAMBDA_HANDLER` |


## `data_flush_timeout`

<applies-to>
  - Application Performance Monitoring Agent for Java: Generally available since 1.28
</applies-to>

This config value allows to specify the timeout in milliseconds for flushing APM data at the end of a serverless function. For serverless functions, APM data is written in a synchronous way, thus, blocking the termination of the function util data is written or the specified timeout is reached.

| Default | Type | Dynamic |
|---------|------|---------|
| `1000`  | Long | false   |


| Java System Properties           | Property file        | Environment                      |
|----------------------------------|----------------------|----------------------------------|
| `elastic.apm.data_flush_timeout` | `data_flush_timeout` | `ELASTIC_APM_DATA_FLUSH_TIMEOUT` |