﻿---
title: Community plugins
description: This page lists some of the plugins developed by the open source community. Have a question about developing a community plugin? You can post questions...
url: https://www.elastic.co/docs/reference/apm/agents/java/community-plugins
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# Community plugins
This page lists some of the plugins developed by the open source community.
Have a question about developing a community plugin? You can post questions and discuss issues in the [Java discussion forum](https://discuss.elastic.co/tag/java).
Have you created a plugin that’s not listed? Add the name and description of your plugin to the source document for [Community Plugins](https://github.com/elastic/apm-agent-java/blob/main/docs/community-plugins.asciidoc) and [open a pull request](https://help.github.com/articles/using-pull-requests) in the [Java agent GitHub repository](https://github.com/elastic/apm-agent-java) to get your change merged.
Want to contribute? [Contributing to the Elastic APM Java agent](https://github.com/elastic/apm-agent-java/blob/main/CONTRIBUTING.md).
<note>
  Elastic provides no warranty or support for community-sourced plugins.
</note>

<definitions>
  <definition term="example repo">
    an example plugin for a custom webserver
  </definition>
  <definition term="apm-jetty-httpclient-plugin">
    Jetty HttpClient plugin
  </definition>
  <definition term="apm-grizzly-asynchttpclient-plugin">
    Grizzly AsyncHttpClient plugin
  </definition>
</definitions>