﻿---
title: APM Java agent
description: The Elastic APM Java Agent automatically measures the performance of your application and tracks errors. It has built-in support for popular frameworks...
url: https://www.elastic.co/docs/reference/apm/agents/java
products:
  - APM Agent
  - APM Java Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Java: Generally available
---

# APM Java agent
The Elastic APM Java Agent automatically measures the performance of your application and tracks errors. It has built-in support for popular frameworks and technologies, as well as a simple [API](https://www.elastic.co/docs/reference/apm/agents/java/public-api) which allows you to instrument any application, and a [Plugin API](https://www.elastic.co/docs/reference/apm/agents/java/plugin-api) that allows you to add custom instrumentation.
<note>
  The minimum required version of the APM Server is 6.5.0
</note>


## How does the Agent work?

The Agent auto-instruments [Supported technologies](/docs/reference/apm/agents/java/set-up-apm-java-agent#supported-technologies) and records interesting events, like spans for database queries and transactions for incoming HTTP requests. To do this, it leverages the capability of the JVM to instrument the bytecode of classes. This means that for the supported technologies, there are no code changes required.
Spans are grouped in transactions — by default, one for each incoming HTTP request. But it’s possible to create custom transactions not associated with an HTTP request. Transactions and Spans are sent to the APM Server, where they’re converted to a format suitable for Elasticsearch. You can then use the APM app in Kibana to gain insight into latency issues and error culprits within your application.
More detailed information on how the Agent works can be found in the [FAQ](/docs/reference/apm/agents/java/frequently-asked-questions#faq-how-does-it-work).

## Additional components

APM Agents work in conjunction with the [APM Server](https://www.elastic.co/docs/solutions/observability/apm), [Elasticsearch](https://www.elastic.co/docs/get-started), and [Kibana](https://www.elastic.co/docs/get-started/the-stack). The [APM Guide](https://www.elastic.co/docs/solutions/observability/apm) provides details on how these components work together, and provides a matrix outlining [Agent and Server compatibility](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility).

## Troubleshooting

If you're experiencing issues with the APM Java agent, refer to [Troubleshoot APM Java Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-java/apm-java-agent).