﻿---
title: Set up the APM Go Agent
description: To start reporting your Go application’s performance to Elastic APM, you need to do a few things: Install the Agent.Instrument Go Source Code.Configure...
url: https://www.elastic.co/docs/reference/apm/agents/go/set-up-apm-go-agent
products:
  - APM Agent
  - APM Go Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Go: Generally available
---

# Set up the APM Go Agent
To start reporting your Go application’s performance to Elastic APM, you need to do a few things:
1. [Install the Agent](#installation).
2. [Instrument Go Source Code](#instrumenting-source).
3. [Configure the Agent](#configure-setup).


## Install the Agent

Within a Go module, install the Elastic APM Go agent package using `go get`:
```bash
go get -u go.elastic.co/apm/v2
```


### Requirements

You can find a list of the supported frameworks and other technologies in the [*Supported Technologies*](https://www.elastic.co/docs/reference/apm/agents/go/supported-technologies) section.

## Instrument Go Source Code

Instrumentation is the process of extending your application’s code to report trace data to Elastic APM. Go applications must be instrumented manually at the source code level. There are two ways to instrument your applications:
- Using [Built-in instrumentation modules](https://www.elastic.co/docs/reference/apm/agents/go/builtin-modules).
- [Custom instrumentation](https://www.elastic.co/docs/reference/apm/agents/go/custom-instrumentation) and [Context propagation](https://www.elastic.co/docs/reference/apm/agents/go/custom-instrumentation-propagation) with the Go Agent API.

Where possible, use the built-in modules to report transactions served by web and RPC frameworks in your application.

## Configure the Agent

To simplify development and testing, the agent defaults to sending data to the Elastic APM Server at `http://localhost:8200`. To send data to an alternative location, you must configure [ELASTIC_APM_SERVER_URL](/docs/reference/apm/agents/go/configuration#config-server-url). Depending on the configuration of your server, you may also need to set [ELASTIC_APM_API_KEY](/docs/reference/apm/agents/go/configuration#config-api-key), [ELASTIC_APM_SECRET_TOKEN](/docs/reference/apm/agents/go/configuration#config-secret-token), and [ELASTIC_APM_VERIFY_SERVER_CERT](/docs/reference/apm/agents/go/configuration#config-verify-server-cert). All other variables have usable defaults.
See [*Configuration*](https://www.elastic.co/docs/reference/apm/agents/go/configuration) to learn about all available options.