﻿---
title: Metrics
description: The Go agent periodically gathers and reports metrics. Control how often metrics are reported with the ELASTIC_APM_METRICS_INTERVAL configuration, and...
url: https://www.elastic.co/docs/reference/apm/agents/go/metrics
products:
  - APM Agent
  - APM Go Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Go: Generally available
---

# Metrics
The Go agent periodically gathers and reports metrics. Control how often metrics are reported with the [`ELASTIC_APM_METRICS_INTERVAL`](/docs/reference/apm/agents/go/configuration#config-metrics-interval) configuration, and disable metrics with [`ELASTIC_APM_DISABLE_METRICS`](/docs/reference/apm/agents/go/configuration#config-disable-metrics).

## System metrics

The Go agent reports basic system-level and process-level CPU and memory metrics. For more system metrics, consider installing [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat) on your hosts.
As of Elastic Stack version 6.6, these metrics will be visualized in the APM app.
In some cases data from multiple nodes will be combined. As of Elastic Stack version 7.5, you will be able to set a unique name for each node to avoid this problem. Otherwise, data will be aggregated separately based on container ID or host name.
<definitions>
  <definition term="system.cpu.total.norm.pct">
    type: scaled_float
  </definition>
</definitions>

format: percent
The percentage of CPU time in states other than Idle and IOWait, normalised by the number of cores.
<definitions>
  <definition term="system.process.cpu.total.norm.pct">
    type: scaled_float
  </definition>
</definitions>

format: percent
The percentage of CPU time spent by the process since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 100%.
<definitions>
  <definition term="system.memory.total">
    type: long
  </definition>
</definitions>

format: bytes
Total memory.
<definitions>
  <definition term="system.memory.actual.free">
    type: long
  </definition>
</definitions>

format: bytes
The actual memory in bytes. It is calculated based on the OS. On Linux it consists of the free memory plus caches and buffers. On OSX it is a sum of free memory and the inactive memory. On Windows, this value does not include memory consumed by system caches and buffers.
<definitions>
  <definition term="system.process.memory.size">
    type: long
  </definition>
</definitions>

format: bytes
The total virtual memory the process has.

## Go runtime metrics

The Go agent reports various Go runtime metrics.
<note>
  As of now, there are no built-in visualizations for these metrics, so you will need to create custom Kibana dashboards for them.
</note>

<definitions>
  <definition term="golang.goroutines">
    type: long
  </definition>
</definitions>

The number of goroutines that currently exist.
<definitions>
  <definition term="golang.heap.allocations.mallocs">
    type: long
  </definition>
</definitions>

The number of mallocs.
<definitions>
  <definition term="golang.heap.allocations.frees">
    type: long
  </definition>
</definitions>

The number of frees.
<definitions>
  <definition term="golang.heap.allocations.objects">
    type: long
  </definition>
</definitions>

The total number of allocated objects.
<definitions>
  <definition term="golang.heap.allocations.total">
    type: long
  </definition>
</definitions>

format: bytes
Bytes allocated (even if freed) throughout the lifetime.
<definitions>
  <definition term="golang.heap.allocations.allocated">
    type: long
  </definition>
</definitions>

format: bytes
Bytes allocated and not yet freed (same as Alloc from [runtime.MemStats](https://golang.org/pkg/runtime/#MemStats)).
<definitions>
  <definition term="golang.heap.allocations.idle">
    type: long
  </definition>
</definitions>

format: bytes
Bytes in idle spans.
<definitions>
  <definition term="golang.heap.allocations.active">
    type: long
  </definition>
</definitions>

format: bytes
Bytes in non-idle spans.
<definitions>
  <definition term="golang.heap.system.total">
    type: long
  </definition>
</definitions>

format: bytes
Total bytes obtained from system (sum of XxxSys from [runtime.MemStats](https://golang.org/pkg/runtime/#MemStats)).
<definitions>
  <definition term="golang.heap.system.obtained">
    type: long
  </definition>
</definitions>

format: bytes
Via HeapSys from [runtime.MemStats](https://golang.org/pkg/runtime/#MemStats), bytes obtained from system. heap_sys = heap_idle + heap_inuse.
<definitions>
  <definition term="golang.heap.system.stack">
    type: long
  </definition>
</definitions>

format: bytes
Bytes of stack memory obtained from the OS.
<definitions>
  <definition term="golang.heap.system.released">
    type: long
  </definition>
</definitions>

format: bytes
Bytes released to the OS.
<definitions>
  <definition term="golang.heap.gc.total_pause.ns">
    type: long
  </definition>
</definitions>

The total garbage collection duration in nanoseconds.
<definitions>
  <definition term="golang.heap.gc.total_count">
    type: long
  </definition>
</definitions>

The total number of garbage collections.
<definitions>
  <definition term="golang.heap.gc.next_gc_limit">
    type: long
  </definition>
</definitions>

format: bytes
Target heap size of the next garbage collection cycle.
<definitions>
  <definition term="golang.heap.gc.cpu_fraction">
    type: float
  </definition>
</definitions>

Fraction of CPU time used by garbage collection.

## Application Metrics

<definitions>
  <definition term="transaction.duration">
    type: simple timer
  </definition>
</definitions>

This timer tracks the duration of transactions and allows for the creation of graphs displaying a weighted average.
Fields:
- `sum.us`: The sum of all transaction durations in microseconds since the last report (the delta)
- `count`: The count of all transactions since the last report (the delta)

You can filter and group by these dimensions:
- `transaction.name`: The name of the transaction
- `transaction.type`: The type of the transaction, for example `request`

<definitions>
  <definition term="transaction.breakdown.count">
    type: long
  </definition>
</definitions>

format: count (delta)
The number of transactions for which breakdown metrics (`span.self_time`) have been created. As the Go agent tracks the breakdown for both sampled and non-sampled transactions, this metric is equivalent to `transaction.duration.count`
You can filter and group by these dimensions:
- `transaction.name`: The name of the transaction
- `transaction.type`: The type of the transaction, for example `request`

<definitions>
  <definition term="span.self_time">
    type: simple timer
  </definition>
</definitions>

This timer tracks the span self-times and is the basis of the transaction breakdown visualization.
Fields:
- `sum.us`: The sum of all span self-times in microseconds since the last report (the delta)
- `count`: The count of all span self-times since the last report (the delta)

You can filter and group by these dimensions:
- `transaction.name`: The name of the transaction
- `transaction.type`: The type of the transaction, for example `request`
- `span.type`: The type of the span, for example `app`, `template` or `db`
- `span.subtype`: The sub-type of the span, for example `mysql` (optional)