﻿---
title: Logs
description: Elastic APM Go Agent provides Log Correlation. The agent will automaticaly inject correlation IDs that allow navigation between logs, traces and services...
url: https://www.elastic.co/docs/reference/apm/agents/go/logs
products:
  - APM Agent
  - APM Go Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Go: Generally available
---

# Logs
Elastic APM Go Agent provides [*Log Correlation*](https://www.elastic.co/docs/reference/apm/agents/go/log-correlation). The agent will automaticaly inject correlation IDs that allow navigation between logs, traces and services.
This features is part of [Application log ingestion strategies](https://www.elastic.co/docs/solutions/observability/logs/stream-application-logs).
The [`ecslogrus`](https://www.elastic.co/docs/reference/ecs/logging/go-logrus) and [`ecszap`](https://www.elastic.co/docs/reference/ecs/logging/go-zap) libraries can also be used to use the [ECS logging](https://www.elastic.co/docs/reference/ecs/logging/intro) format without an APM agent. When deployed with the Go APM agent, the agent will provide [log correlation](https://www.elastic.co/docs/reference/apm/agents/go/log-correlation) IDs.
The Go agent provides integrations for popular logging frameworks that inject trace ID fields into the application’s log records. You can find a list of the supported logging frameworks under [supported technologies](/docs/reference/apm/agents/go/supported-technologies#supported-tech-logging).
If your favorite logging framework is not already supported, there are two other options:
- Open a feature request, or contribute code, for additional support as described in [*Contributing*](https://www.elastic.co/docs/reference/apm/agents/go/contributing).
- Manually inject trace IDs into log records, as described below in [Manual log correlation](/docs/reference/apm/agents/go/log-correlation#log-correlation-manual).