﻿---
title: APM Go agent
description: The Elastic APM Go Agent enables you to trace the execution of operations in your Go applications, sending performance metrics and errors to the Elastic...
url: https://www.elastic.co/docs/reference/apm/agents/go
products:
  - APM Agent
  - APM Go Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Go: Generally available
---

# APM Go agent
The Elastic APM Go Agent enables you to trace the execution of operations in your [Go](https://golang.org/) applications, sending performance metrics and errors to the Elastic APM server. It has built-in support for popular frameworks and toolkits, like [Gorilla](http://www.gorillatoolkit.org/) and [Gin](https://gin-gonic.com/), as well as support for instrumenting Go’s built-in [net/http](https://golang.org/pkg/net/http/), [database/sql](https://golang.org/pkg/database/sql/) drivers. The Agent also offers an [*API Documentation*](https://www.elastic.co/docs/reference/apm/agents/go/api-documentation) for custom instrumentation.

## How does the Agent work?

The Agent includes instrumentation modules for [*Supported Technologies*](https://www.elastic.co/docs/reference/apm/agents/go/supported-technologies), each providing middleware or wrappers for recording interesting events, such as incoming HTTP requests, outgoing HTTP requests, and database queries.
To collect data about incoming HTTP requests, install router middleware for one of the supported [Web Frameworks](/docs/reference/apm/agents/go/supported-technologies#supported-tech-web-frameworks). Incoming requests will be recorded as transactions, along with any related panics or errors.
To collect data for outgoing HTTP requests, instrument an `http.Client` or `http.Transport` using [module/apmhttp](/docs/reference/apm/agents/go/builtin-modules#builtin-modules-apmhttp). To collect data about database queries, use [module/apmsql](/docs/reference/apm/agents/go/builtin-modules#builtin-modules-apmsql), which provides instrumentation for well known database drivers.
In order to connect transactions with related spans and errors, and propagate traces between services (distributed tracing), the agent relies on Go’s built-in [context](https://golang.org/pkg/context/) package: transactions and spans are stored in context objects. For example, for incoming HTTP requests, in-flight trace data will be recorded in the `context` object accessible through [net/http.Context](https://golang.org/pkg/net/http/#Request.Context). Read more about this in [Context propagation](https://www.elastic.co/docs/reference/apm/agents/go/custom-instrumentation-propagation).
In addition to capturing events like those mentioned above, the agent also collects system and application metrics at regular intervals. This collection happens in a background goroutine that is automatically started when the agent is initialized.

## Additional Components

APM Agents work in conjunction with the [APM Server](https://www.elastic.co/docs/solutions/observability/apm), [Elasticsearch](https://www.elastic.co/docs/get-started), and [Kibana](https://www.elastic.co/docs/get-started/the-stack). The [APM Guide](https://www.elastic.co/docs/solutions/observability/apm) provides details on how these components work together, and provides a matrix outlining [Agent and Server compatibility](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility).

## Troubleshooting

If you're experiencing issues with the APM Go agent, refer to [Troubleshoot APM Go Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-go/apm-go-agent).