﻿---
title: Supported technologies
description: The APM Agent for .NET targets every .NET flavor and version that supports .NET Standard 2.0 or .NET Standard 2.1. However, we only test and support .NET...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/supported-technologies
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Supported technologies
## .NET versions

The APM Agent for .NET targets every .NET flavor and version that supports .NET Standard 2.0 or .NET Standard 2.1.
However, we only test and support .NET runtimes that are also supported per the [Microsoft .NET support policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core). Therefore, we always recommend you upgrade to a supported runtime before raising issues.
<note>
  On .NET Framework, due to binding issues introduced by Microsoft, we recommend at least .NET Framework 4.7.2 for best compatibility.
</note>


## Web frameworks

Automatic instrumentation for a web framework means a transaction is automatically created for each incoming request and it is named after the registered route.
Automatic instrumentation is supported for the following web frameworks

| Framework                                                                                                                                  | Supported versions   | Integration                                                                                                                                                                                                       |
|--------------------------------------------------------------------------------------------------------------------------------------------|----------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| ASP.NET Core <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.0</applies-to>                     | ≥8.0.0 <10.0.0       | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-asp-net-core)                                                                                                                       |
| ASP.NET (.NET Framework) in IIS  <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.1</applies-to> | 4.6.2-4.8.1 (IIS 10) | [Profiler auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation)*or*[NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-asp-dot-net) |

<note>
  We support ASP.NET on IIS 10 versions supported by Microsoft per their [IIS support policy](https://learn.microsoft.com/lifecycle/products/internet-information-services-iis).
  IIS must be installed on a [supported](https://learn.microsoft.com/windows/release-health/windows-server-release-info#windows-server-major-versions-by-servicing-option--) Windows operating system version.
</note>

<note>
  APM Agent auto instrumentation does not support the Web Garden (multi-worker process) mode of IIS.
</note>


## RPC Frameworks

The agent supports gRPC on .NET both on the client and the server side. Every gRPC call is automatically captured by the agent.
Streaming is not supported; for streaming use-cases, the agent does not create transactions and spans automatically.

| Framework                                                                                                      | Supported versions                             | Integration                                                                                 |
|----------------------------------------------------------------------------------------------------------------|------------------------------------------------|---------------------------------------------------------------------------------------------|
| gRPC <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.7</applies-to> | Grpc.Net.Client ≥2.23.2 <3.0.0 *(client side)* | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-grpc)         |
| ASP.NET Core                                                                                                   | ≥8.0.0 <10.0.0 *(server side)*                 | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-asp-net-core) |


## Data access technologies

Automatic instrumentation is supported for the following data access technologies

| Data access technology                                                                                                          | Supported versions                                                                      | Integration                                                                                                         |
|---------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------|
| Azure CosmosDB <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.11</applies-to>       | Microsoft.Azure.Cosmos ≥3.0.0 <4.0.0                                                    | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-cosmosdb)                       |
| Azure DocumentDb <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.11</applies-to>     | Microsoft.Azure.DocumentDB.Core* ≥2.4.1 <3.0.0Microsoft.Azure.DocumentDB* ≥2.4.1 <3.0.0 | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-cosmosdb)                       |
| Entity Framework Core <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.0</applies-to> | Microsoft.EntityFrameworkCore ≥8.0.0 <10.0.0                                            | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-ef-core)                              |
| Entity Framework 6 <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.2</applies-to>    | EntityFramework 6.2-6.5.1                                                               | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-ef6)                                  |
| Elasticsearch <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.23</applies-to>        | Elastic.Clients.Elasticsearch ≥8.0.0 <10.0.0                                            | [OpenTelemetry Bridge](https://www.elastic.co/docs/reference/apm/agents/dotnet/opentelemetry-bridge)                |
| MySQL <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.12</applies-to>                | See profiler documentation                                                              | [Profiler auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation) |
| MongoDB                                                                                                                         | MongoDB.Driver ≥3.0.0 <4.0.0                                                            | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-mongo-db)                             |
| Oracle <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.12</applies-to>               | See profiler documentation                                                              | [Profiler auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation) |
| PostgreSQL <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.12</applies-to>           | See profiler documentation                                                              | [Profiler auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation) |
| Redis <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.8</applies-to>                 | StackExchange.Redis ≥2.0.495 <3.0.0                                                     | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-stackexchange-redis)                  |
| SqlClient <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.8</applies-to>             | System.Data.SqlClient ≥2.0.495 <5.0.0                                                   | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-sqlclient)                            |
| SQLite <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.12</applies-to>               | See profiler documentation                                                              | [Profiler auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation) |

<note>
  * `Microsoft.Azure.DocumentDB.Core` and `Microsoft.Azure.DocumentDB` are deprecated. The recommended replacement is the `Microsoft.Azure.Cosmos` package.
</note>


## Messaging systems

We support automatic instrumentation for the following messaging systems

| Messaging system                                                                                                               | Supported versions                                                               | Integration                                                                                                                                                                                             |
|--------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Azure Service Bus <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.10</applies-to>   | Microsoft.Azure.ServiceBus ≥3.0.0 <6.0.0Azure.Messaging.ServiceBus ≥7.0.0 <8.0.0 | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-servicebus)                                                                                                         |
| Azure Queue Storage <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.10</applies-to> | Azure.Storage.Queues ≥12.6.0 <13.0.0                                             | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-storage)                                                                                                            |
| Kafka <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.12</applies-to>               | See profiler documentationConfluent.Kafka ≥2.11.1 <3.0.0                         | [Profiler auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation)[NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-kafka) |
| RabbitMQ <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.12</applies-to>            | See profiler documentation                                                       | [Profiler auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation)                                                                                     |


## Networking client-side technologies

Automatic instrumentation for networking client-side technology means an HTTP span is automatically created for each outgoing HTTP request and tracing headers are propagated.

| Framework                                                                                                                            | Supported versions | Integration                                                                    |
|--------------------------------------------------------------------------------------------------------------------------------------|--------------------|--------------------------------------------------------------------------------|
| System.Net.Http.HttpClient <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.0</applies-to> | *built-in*         | [part of Elastic.Apm](/docs/reference/apm/agents/dotnet/public-api#setup-http) |
| System.Net.HttpWebRequest <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.1</applies-to>  | *built-in*         | [part of Elastic.Apm](/docs/reference/apm/agents/dotnet/public-api#setup-http) |


## Cloud services

Automatic instrumentation for the following cloud services

| Cloud service                                                                                                                   | Supported versions                                                                      | Integration                                                                                     |
|---------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------|
| Azure CosmosDB <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.11</applies-to>       | Microsoft.Azure.Cosmos ≥3.0.0 <4.0.0                                                    | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-cosmosdb)   |
| Azure DocumentDb <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.11</applies-to>     | Microsoft.Azure.DocumentDB.Core* ≥2.4.1 <3.0.0Microsoft.Azure.DocumentDB* ≥2.4.1 <3.0.0 | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-cosmosdb)   |
| Azure Service Bus <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.10</applies-to>    | Microsoft.Azure.ServiceBus ≥3.0.0 <6.0.0Azure.Messaging.ServiceBus ≥7.0.0 <8.0.0        | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-servicebus) |
| Azure Storage <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.10</applies-to>        | Azure.Storage.Blobs ≥12.8.0 <13.0.0                                                     | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-storage)    |
| Azure Storage Queues <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.10</applies-to> | Azure.Storage.Queues ≥12.6.0 <13.0.0                                                    | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-storage)    |
| Azure Storage Files <applies-to>Application Performance Monitoring Agent for .NET: Generally available since 1.10</applies-to>  | Azure.Storage.Files.Shares ≥12.6.0 <13.0.0                                              | [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-storage)    |

<note>
  * `Microsoft.Azure.DocumentDB.Core` and `Microsoft.Azure.DocumentDB` are deprecated. The recommended replacement is the `Microsoft.Azure.Cosmos` package.
</note>