﻿---
title: StackExchange.Redis
description: Instrumentation can be enabled for StackExchange.Redis by referencing Elastic.Apm.StackExchange.Redis package and calling the UseElasticApm() extension...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-stackexchange-redis
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# StackExchange.Redis
## Quick start

Instrumentation can be enabled for `StackExchange.Redis` by referencing [`Elastic.Apm.StackExchange.Redis`](https://www.nuget.org/packages/Elastic.Apm.StackExchange.Redis) package and calling the `UseElasticApm()` extension method defined in `Elastic.Apm.StackExchange.Redis`, on `IConnectionMultiplexer`
```csharp
// using Elastic.Apm.StackExchange.Redis;

var connection = await ConnectionMultiplexer.ConnectAsync("<redis connection>");
connection.UseElasticApm();
```

A callback is registered with the `IConnectionMultiplexer` to provide a profiling session for each transaction and span that captures redis commands sent with `IConnectionMultiplexer`.