﻿---
title: SqlClient
description: You can enable auto instrumentation for System.Data.SqlClient or Microsoft.Data.SqlClient by referencing Elastic.Apm.SqlClient package and passing SqlClientDiagnosticSubscriber...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-sqlclient
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# SqlClient
## Quick start

You can enable auto instrumentation for `System.Data.SqlClient` or `Microsoft.Data.SqlClient` by referencing [`Elastic.Apm.SqlClient`](https://www.nuget.org/packages/Elastic.Apm.SqlClient) package and passing `SqlClientDiagnosticSubscriber` to the `AddElasticApm` method in case of ASP.NET Core as it shown in example:
```csharp
// Enable tracing of outgoing db requests
app.Services.AddElasticApm(new SqlClientDiagnosticSubscriber());
```

or passing `SqlClientDiagnosticSubscriber` to the `Subscribe` method and make sure that the code is called only once, otherwise the same database call could be captured multiple times:
```csharp
// Enable tracing of outgoing db requests
Agent.Subscribe(new SqlClientDiagnosticSubscriber());
```

<note>
  Auto instrumentation  for `System.Data.SqlClient` is available for both .NET and .NET Framework applications, however, support of .NET Framework has one limitation: command text cannot be captured.Auto instrumentation for `Microsoft.Data.SqlClient` is available only for .NET at the moment.As an alternative to using the `Elastic.Apm.SqlClient` package to instrument database calls, see [Profiler Auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation).
</note>