﻿---
title: MongoDB
description: Instrumentation for MongoDB works with the official MongoDb.Driver driver packages. A prerequisite for auto instrumentation is to configure the MongoClient...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-mongo-db
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# MongoDB
## Quick start

Instrumentation for MongoDB works with the official MongoDb.Driver driver packages. A prerequisite for auto instrumentation is to configure the `MongoClient` with `MongoDbEventSubscriber`:
```csharp
var settings = MongoClientSettings.FromConnectionString(mongoConnectionString);

settings.ClusterConfigurator = builder => builder.Subscribe(new MongoDbEventSubscriber());
var mongoClient = new MongoClient(settings);
```

Once the above configuration is in place
- if the agent is included by referencing the `Elastic.Apm.NetCoreAll` package, it will automatically capture calls to MongoDB on every active transaction, and no further action is required.
- you can manually activate auto instrumentation from the `Elastic.Apm.MongoDb` package by calling

```csharp
Agent.Subscribe(new MongoDbDiagnosticsSubscriber());
```

<important>
  MongoDB integration is currently supported on .NET runtimes. Due to MongoDb.Driver assemblies not being strongly named, they cannot be used with Elastic APM’s strongly named assemblies on .NET Framework.
</important>