﻿---
title: gRPC
description: Automatic instrumentation for gRPC can be enabled for both client-side and server-side gRPC calls. Automatic instrumentation for ASP.NET Core server-side...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-grpc
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# gRPC
## Quick start

Automatic instrumentation for gRPC can be enabled for both client-side and server-side gRPC calls.
Automatic instrumentation for ASP.NET Core server-side is built in to [NuGet package](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-asp-net-core)
Automatic instrumentation can be enabled for the client-side by referencing [`Elastic.Apm.GrpcClient`](https://www.nuget.org/packages/Elastic.Apm.GrpcClient) package and passing `GrpcClientDiagnosticListener` to the `AddElasticApm` method in case of ASP.NET Core
```csharp
app.Services.AddElasticApm(new GrpcClientDiagnosticListener());
```

or passing `GrpcClientDiagnosticSubscriber` to the `Subscribe` method
```csharp
Agent.Subscribe(new GrpcClientDiagnosticSubscriber());
```

Diagnostic events from `Grpc.Net.Client` are captured as spans.