﻿---
title: Other .NET applications
description: If you have a .NET application that is not covered in this section, you can still use the agent and instrument your application manually. To do this,...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-general
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Other .NET applications
If you have a .NET application that is not covered in this section, you can still use the agent and instrument your application manually.
To do this, add the [Elastic.Apm](https://www.nuget.org/packages/Elastic.Apm) package to your application and use the [*Public API*](https://www.elastic.co/docs/reference/apm/agents/dotnet/public-api)
or .NET [Activity](https://learn.microsoft.com/dotnet/core/diagnostics/distributed-tracing-instrumentation-walkthroughs) APIs to manually create spans and transactions.
<important>
  For best flexibility and reduced vendor lock-in, we recommend preferring that custom instrumentation uses the [System.Diagnostics.Activity](https://learn.microsoft.com/dotnet/api/system.diagnostics.activity) API. Code instrumented with this API will be picked up by the OpenTelemetry Bridge and is also natively
  compatible with OpenTelemetry.
</important>