﻿---
title: Entity Framework Core
description: Instrumentation can be enabled for Entity Framework Core by referencing Elastic.Apm.EntityFrameworkCore package and passing EfCoreDiagnosticsSubscriber...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-ef-core
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Entity Framework Core
## Quick start

Instrumentation can be enabled for Entity Framework Core by referencing [`Elastic.Apm.EntityFrameworkCore`](https://www.nuget.org/packages/Elastic.Apm.EntityFrameworkCore) package and passing `EfCoreDiagnosticsSubscriber` to the `AddElasticApm` method in case of ASP.NET Core, as follows:
```csharp
app.Services.AddElasticApm(new EfCoreDiagnosticsSubscriber());
```

or passing `EfCoreDiagnosticsSubscriber` to the `Subscribe` method
```csharp
Agent.Subscribe(new EfCoreDiagnosticsSubscriber());
```

Instrumentation listens for diagnostic events raised by `Microsoft.EntityFrameworkCore`, creating database spans for executed commands.