﻿---
title: Set up the APM .NET agent
description: The .NET agent can be added to an application in three different ways Profiler Auto instrumentation, ASP.NET Core, .NET, ASP.NET, Azure Functions, Manual...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/set-up-apm-net-agent
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Set up the APM .NET agent
The .NET agent can be added to an application in three different ways
<definitions>
  <definition term="Profiler runtime instrumentation">
    The agent supports auto instrumentation without any code change and without any recompilation of your projects. See [Profiler Auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation).
  </definition>
  <definition term="NuGet packages">
    The agent ships as a set of [NuGet packages](https://www.elastic.co/docs/reference/apm/agents/dotnet/nuget-packages) available on [nuget.org](https://nuget.org). You can add the Agent and specific instrumentations to a .NET application by referencing one or more of these packages and following the package documentation.
  </definition>
  <definition term="Host startup hook">
    On **.NET**, the agent supports auto instrumentation without any code change and without any recompilation of your projects. See [Zero code change setup on .NET](/docs/reference/apm/agents/dotnet/setup-dotnet-net-core#zero-code-change-setup) for more details.
  </definition>
</definitions>


## Get started

- [Profiler Auto instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-auto-instrumentation)
- [ASP.NET Core](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-asp-net-core)
- [.NET](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-dotnet-net-core)
- [ASP.NET](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-asp-dot-net)
- [Azure Functions](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-functions)
- [Manual instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-general)