﻿---
title: Performance tuning
description: There are many options available to tune agent performance. Which option to adjust depends on whether you are optimizing for speed, memory usage, bandwidth...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/performance-tuning
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Performance tuning
There are many options available to tune agent performance. Which option to adjust depends on whether you are optimizing for speed, memory usage, bandwidth or storage.

## Sampling

The first knob to reach for when tuning the performance of the agent is [`TransactionSampleRate`](/docs/reference/apm/agents/dotnet/config-core#config-transaction-sample-rate). Adjusting the sample rate controls what percent of requests are traced. By default, the sample rate is set at `1.0`, meaning *all* requests are traced.
The sample rate will impact all four performance categories, so simply turning down the sample rate is an easy way to improve performance.
Here’s an example of setting the sample rate to 20% using [Configuration on ASP.NET Core](https://www.elastic.co/docs/reference/apm/agents/dotnet/configuration-on-asp-net-core):
```js
{
    "ElasticApm": {
        "TransactionSampleRate": 0.2
    }
}
```


## Stack traces

In a complex application, a request may produce many spans. Capturing a stack trace for every span can result in significant memory usage. Stack traces are also captured for every error. There are several settings to adjust how stack traces are captured.

### Disable capturing stack traces

To disable capturing stack traces (for both spans and errors), set [`StackTraceLimit`](/docs/reference/apm/agents/dotnet/config-stacktrace#config-stack-trace-limit) to `0`.

### Capture stack traces only for long running spans

In its default settings, the APM agent collects a stack trace for every recorded span with duration longer than 5ms. To increase the duration threshold, set [`SpanStackTraceMinDuration`](/docs/reference/apm/agents/dotnet/config-stacktrace#config-span-stack-trace-min-duration).

### Reduce number of captured stack trace frames

The [`StackTraceLimit`](/docs/reference/apm/agents/dotnet/config-stacktrace#config-stack-trace-limit) controls how many stack frames should be collected when a capturing stack trace.

## Disable capturing HTTP request and response headers

Capturing HTTP request and response headers increases memory allocations, network bandwidth and disk space used by Elasticsearch. To disable capturing HTTP request and response headers, set [`CaptureHeaders`](/docs/reference/apm/agents/dotnet/config-http#config-capture-headers) to `false`.

## Increase metrics collection interval

The .NET agent tracks certain system and application metrics. These metrics are regularly collected and sent to the APM Server and from there to Elasticsearch. You can adjust the interval for metrics collection with the setting [`MetricsInterval`](/docs/reference/apm/agents/dotnet/config-reporter#config-metrics-interval).