﻿---
title: NuGet packages
description: Agent instrumentations are released as a set of NuGet packages available on nuget.org. You can add the Agent and specific instrumentations to your .NET...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/nuget-packages
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# NuGet packages
Agent instrumentations are released as a set of NuGet packages available on [nuget.org](https://nuget.org). You can add the Agent and specific instrumentations to your .NET application by referencing one or more of these packages.

## Get started

- [Azure Cosmos DB](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-cosmosdb)
- [Azure Service Bus](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-servicebus)
- [Azure Storage](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-azure-storage)
- [Entity Framework 6](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-ef6)
- [Entity Framework Core](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-ef-core)
- [Elasticsearch](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-elasticsearch)
- [gRPC](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-grpc)
- [MongoDB](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-mongo-db)
- [SqlClient](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-sqlclient)
- [StackExchange.Redis](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-stackexchange-redis)


## Packages

The following NuGet packages are available:
<definitions>
  <definition term="Elastic.Apm">
    The core agent package, contains the [*Public API*](https://www.elastic.co/docs/reference/apm/agents/dotnet/public-api) of the agent. It also contains every tracing component to trace classes that are part of .NET Standard 2.0, which includes the monitoring part for `HttpClient`. Every other Elastic APM package references this package.
  </definition>
  <definition term="Elastic.Apm.NetCoreAll">
    A meta package that references all other Elastic APM .NET agent package that can automatically configure instrumentation.
    If you plan to monitor a typical ASP.NET Core application that depends on the [Microsoft.AspNetCore.All](https://www.nuget.org/packages/Microsoft.AspNetCore.All) package, you should reference this package.
    In order to avoid adding unnecessary dependencies in applications that aren’t dependent on the [Microsoft.AspNetCore.All](https://www.nuget.org/packages/Microsoft.AspNetCore.All) package, we also offer some other packages - those are all referenced by the `Elastic.Apm.NetCoreAll` package.
  </definition>
  <definition term="Elastic.Apm.Extensions.Hosting ([1.6.0-beta])">
    A package for agent registration integration with `Microsoft.Extensions.Hosting.IHostBuilder` registration.
  </definition>
</definitions>


<definitions>
  <definition term="Elastic.Apm.AspNetCore">
    A package for instrumenting ASP.NET Core applications. The main difference between this package and the `Elastic.Apm.NetCoreAll` package is that this package only instruments ASP.NET Core by default, whereas `Elastic.Apm.NetCoreAll` instruments all components that can be automatically configured, such as Entity Framework Core, HTTP calls with `HttpClient`, database calls to SQL Server with `SqlClient`, etc. Additional instrumentations can be added when using `Elastic.Apm.AspNetCore` by referencing the respective NuGet packages and including their configuration code in agent setup.
  </definition>
  <definition term="Elastic.Apm.AspNetFullFramework">
    A package containing ASP.NET .NET Framework instrumentation.
  </definition>
  <definition term="Elastic.Apm.Azure.CosmosDb">
    A package containing instrumentation to capture spans for Azure Cosmos DB with [Microsoft.Azure.Cosmos](https://www.nuget.org/packages/Microsoft.Azure.Cosmos), [Microsoft.Azure.DocumentDb](https://www.nuget.org/packages/Microsoft.Azure.DocumentDb), and [Microsoft.Azure.DocumentDb.Core](https://www.nuget.org/packages/Microsoft.Azure.DocumentDb.Core) packages.
  </definition>
  <definition term="Elastic.Apm.Azure.ServiceBus">
    A package containing instrumentation to capture transactions and spans for messages sent and received from Azure Service Bus with [Microsoft.Azure.ServiceBus](https://www.nuget.org/packages/Microsoft.Azure.ServiceBus/) and [Azure.Messaging.ServiceBus](https://www.nuget.org/packages/Azure.Messaging.ServiceBus/) packages.
  </definition>
  <definition term="Elastic.Apm.Azure.Storage">
    A package containing instrumentation to capture spans for interaction with Azure Storage with [Azure.Storage.Queues](https://www.nuget.org/packages/azure.storage.queues/), [Azure.Storage.Blobs](https://www.nuget.org/packages/azure.storage.blobs/) and [Azure.Storage.Files.Shares](https://www.nuget.org/packages/azure.storage.files.shares/) packages.
  </definition>
  <definition term="Elastic.Apm.EntityFrameworkCore">
    A package containing Entity Framework Core instrumentation.
  </definition>
  <definition term="Elastic.Apm.EntityFramework6">
    A package containing an interceptor to automatically create spans for database operations executed by Entity Framework 6 on behalf of the application.
  </definition>
  <definition term="Elastic.Apm.MongoDb">
    A package containing support for [MongoDB.Driver](https://www.nuget.org/packages/MongoDB.Driver/).
  </definition>
  <definition term="Elastic.Apm.SqlClient">
    A package containing [System.Data.SqlClient](https://www.nuget.org/packages/System.Data.SqlClient) and [Microsoft.Data.SqlClient](https://www.nuget.org/packages/Microsoft.Data.SqlClient) instrumentation.
  </definition>
</definitions>

<note>
  this functionality now included by default in `Elastic.Apm` as of 1.24.0
</note>

<definitions>
  <definition term="Elastic.Apm.StackExchange.Redis">
    A package containing instrumentation to capture spans for commands sent to redis with [StackExchange.Redis](https://www.nuget.org/packages/StackExchange.Redis/) package.
  </definition>
</definitions>