﻿---
title: Metrics
description: The .NET agent tracks certain system and application metrics. Some of them have built-in visualizations and some can only be visualized with custom Kibana...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/metrics
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Metrics
The .NET agent tracks certain system and application metrics. Some of them have built-in visualizations and some can only be visualized with custom Kibana dashboards.
These metrics will be sent regularly to the APM Server and from there to Elasticsearch. You can adjust the interval with the setting [`MetricsInterval`](/docs/reference/apm/agents/dotnet/config-reporter#config-metrics-interval).
The metrics will be stored in the `apm-*` index and have the `processor.event` property set to `metric`.
"Platform: all" means that the metric is available on every platform where .NET (i.e. not .NET Framework) is supported.

## System metrics

As of APM version 6.6, these metrics will be visualized in the APM app.
<important>
  System CPU usage metric is collected using Performance Counters on Windows. The account under which a traced application runs must be part of the **Performance Monitor Users** group to be able to access performance counter values.An account can be added to the **Performance Monitor Users** group from the command line
  ```sh
  net localgroup "Performance Monitor Users" "<Account Name>" /add 
  ```
  For applications running in IIS, [IIS application pool identities use *virtual* accounts](https://docs.microsoft.com/en-us/iis/manage/configuring-security/application-pool-identities) with a name following the convention `IIS APPPOOL\<Application pool name>`. An individual application pool identity can be added to the **Performance Monitor Users** group using the `net localgroup` command above.
</important>

For more system metrics, consider installing [metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat) on your hosts.
<definitions>
  <definition term="system.cpu.total.norm.pct">
    type: scaled_float
  </definition>
</definitions>

format: percent
platform: Windows and Linux only
The percentage of CPU time in states other than Idle and IOWait, normalized by the number of cores.
<definitions>
  <definition term="system.process.cpu.total.norm.pct">
    type: scaled_float
  </definition>
</definitions>

format: percent
platform: all
The percentage of CPU time spent by the process since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 100%.
<definitions>
  <definition term="system.memory.total">
    type: long
  </definition>
</definitions>

format: bytes
Platform: Windows and Linux only.
Total memory.
<definitions>
  <definition term="system.memory.actual.free">
    type: long
  </definition>
</definitions>

format: bytes
Platform: Windows and Linux only.
Actual free memory.
<definitions>
  <definition term="system.process.memory.size">
    type: long
  </definition>
</definitions>

format: bytes
platform: all
The total virtual memory the process has.
<definitions>
  <definition term="system.process.memory.rss.bytes">
    type: long
  </definition>
</definitions>

format: bytes
platform: all
The total physical memory the process has.

## Runtime metrics

<definitions>
  <definition term="clr.gc.count">
    type: long
  </definition>
</definitions>

Platform: all.
The total number of GC collections that have occurred.
<definitions>
  <definition term="clr.gc.gen0size">
    type: long
  </definition>
</definitions>

format: bytes
Platform: all.
The size of the generation 0 heap.
<definitions>
  <definition term="clr.gc.gen1size">
    type: long
  </definition>
</definitions>

format: bytes
Platform: all.
The size of the generation 1 heap.
<definitions>
  <definition term="clr.gc.gen2size">
    type: long
  </definition>
</definitions>

format: bytes
Platform: all.
The size of the generation 2 heap.
<definitions>
  <definition term="clr.gc.gen3size">
    type: long
  </definition>
</definitions>

format: bytes
Platform: all.
The size of the generation 3 heap - also known as Large Object Heap (LOH).
<definitions>
  <definition term="clr.gc.time">
    type: long
  </definition>
</definitions>

format: ms
Platform: all.
The approximate accumulated collection elapsed time in milliseconds.

## Built-in application metrics

To power the [Time spent by span type](https://www.elastic.co/docs/solutions/observability/apm/transactions-ui) graph, the agent collects summarized metrics about the timings of spans and transactions, broken down by span type.
<definitions>
  <definition term="transaction.duration">
    type: simple timer
  </definition>
</definitions>

This timer tracks the duration of transactions and allows for the creation of graphs displaying a weighted average.
Fields:
- `sum.us`: The sum of all transaction durations in microseconds since the last report (the delta)
- `count`: The count of all transactions since the last report (the delta)

You can filter and group by these dimensions:
- `transaction.name`: The name of the transaction
- `transaction.type`: The type of the transaction, for example `request`

<definitions>
  <definition term="transaction.breakdown.count">
    type: long
  </definition>
</definitions>

format: count (delta)
The number of transactions for which breakdown metrics (`span.self_time`) have been created. As the Java agent tracks the breakdown for both sampled and non-sampled transactions, this metric is equivalent to `transaction.duration.count`
You can filter and group by these dimensions:
- `transaction.name`: The name of the transaction
- `transaction.type`: The type of the transaction, for example `request`

<definitions>
  <definition term="span.self_time">
    type: simple timer
  </definition>
</definitions>

This timer tracks the span self-times and is the basis of the transaction breakdown visualization.
Fields:
- `sum.us`: The sum of all span self-times in microseconds since the last report (the delta)
- `count`: The count of all span self-times since the last report (the delta)

You can filter and group by these dimensions:
- `transaction.name`: The name of the transaction
- `transaction.type`: The type of the transaction, for example `request`
- `span.type`: The type of the span, for example `app`, `template` or `db`
- `span.subtype`: The sub-type of the span, for example `mysql` (optional)