﻿---
title: Logs
description: Elastic .NET Agent provides Log correlation. The agent will automaticaly inject correlation IDs that allow navigation between logs, traces and services...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/logs
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Logs
Elastic .NET Agent provides [Log correlation](#log-correlation-ids). The agent will automaticaly inject correlation IDs that allow navigation between logs, traces and services.
This features is part of [Application log ingestion strategies](https://www.elastic.co/docs/solutions/observability/logs/stream-application-logs).
The [`ecs-logging-dotnet`](https://www.elastic.co/docs/reference/ecs/logging/dotnet) library can also be used to use the [ECS logging](https://www.elastic.co/docs/reference/ecs/logging/intro) format without an APM agent. ECS .NET logging will always provide [log correlation](#log-correlation-ids) IDs through [`System.Diagnostics.Activity`](https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.activity?view=net-7.0). When paired with the APM Agent it will pick up the appropriate service correlation features too.

## Log correlation

The Elastic APM .NET agent provides integrations for popular logging frameworks, which take care of injecting trace ID fields into your application’s log records. Currently supported logging frameworks are:
- [Serilog](https://www.elastic.co/docs/reference/apm/agents/dotnet/serilog)
- [NLog](https://www.elastic.co/docs/reference/apm/agents/dotnet/nlog)

If your favorite logging framework is not already supported, there are two other options:
- Open a feature request, or contribute code, for additional support, as described in [CONTRIBUTING.md](https://github.com/elastic/apm-agent-dotnet/blob/main/CONTRIBUTING.md).
- Manually inject trace IDs into log records, as described in [Manual log correlation](https://www.elastic.co/docs/reference/apm/agents/dotnet/log-correlation-manual).

Regardless of how you integrate APM with logging, you can use [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat) to send your logs to Elasticsearch, in order to correlate your traces and logs and link from APM to the [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs).