﻿---
title: Configuration
description: Utilize configuration options to adapt the Elastic APM agent to your needs. There are multiple configuration sources, each with different naming conventions...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/configuration
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Configuration
Utilize configuration options to adapt the Elastic APM agent to your needs. There are multiple configuration sources, each with different naming conventions for the property key.
By default, the agent uses environment variables. Additionally, on ASP.NET Core, the agent plugs into the [Microsoft.Extensions.Configuration](https://learn.microsoft.com/aspnet/core/fundamentals/configuration) infrastructure.

## Dynamic configuration

Configuration options that are marked with the ![dynamic config](https://www.elastic.co/docs/reference/apm/agents/dotnet/images/dynamic-config.svg) badge can be changed at runtime when set from a supported source.
The .NET Agent supports [Central configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/central-configuration), which allows you to fine-tune certain configurations via the APM app. This feature is enabled in the Agent by default, with [`CentralConfig` ([1.1])](/docs/reference/apm/agents/dotnet/config-core#config-central-config).