﻿---
title: Configuration on ASP.NET Core
description: The AddElasticApm() extension method on the IServiceCollection automatically accesses configuration bound via the Microsoft.Extensions.Configuration sources...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/configuration-on-asp-net-core
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Configuration on ASP.NET Core
The `AddElasticApm()` extension method on the `IServiceCollection` automatically accesses configuration bound via the `Microsoft.Extensions.Configuration` sources. To use this type of setup, which is typical in an ASP.NET Core application, your application’s `Program.cs` file should contain code similar to the following:
```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Services.AddAllElasticApm();

var app = builder.Build();

// Configure the HTTP request pipeline.

app.Run();
```

With this setup, the Agent is able to be configured in the same way as any other library in your application. For example, any configuration source that has been configured on the `IConfiguration` instance in use in the application can be used to set Agent configuration values.
More information is available in the official [Microsoft .NET Core configuration docs](https://learn.microsoft.com/aspnet/core/fundamentals/configuration) You can find the key for each APM configuration option in this documentation, under the `IConfiguration or Web.config key` column of the option’s description.
<note>
  The `AddElasticApm` method only turns on ASP.NET Core monitoring. To turn on tracing for everything supported by the Agent on .NET Core, including HTTP and database monitoring, use the `AddAllElasticApm` method from the `Elastic.Apm NetCoreAll` package. Learn more in [ASP.NET Core setup](https://www.elastic.co/docs/reference/apm/agents/dotnet/setup-asp-net-core).
</note>


## Sample configuration file

Here is a sample `appsettings.json` configuration file for a typical ASP.NET Core application that has been activated with `AddElasticApm()`. There is one important takeaway, listed as a callout below the example:
```js
{
  "Logging": {
    "LogLevel": { 
      "Default": "Warning",
      "Elastic.Apm": "Debug"
    }
  },
  "AllowedHosts": "*",
  "ElasticApm":
    {
      "ServerUrl":  "http://myapmserver:8200",
      "SecretToken":  "apm-server-secret-token",
      "TransactionSampleRate": 1.0
    }
}
```

In certain scenarios— like when you’re not using ASP.NET Core— you won’t activate the agent with the `AddElasticApm()` method. In this case, set the agent log level with [`ElasticApm:LogLevel`](/docs/reference/apm/agents/dotnet/config-supportability#config-log-level), as shown in the following `appsettings.json` file:
```js
{
  "Logging": {
    "LogLevel": {
      "Default": "Warning"
    }
  },
  "AllowedHosts": "*",
  "ElasticApm":
    {
      "LogLevel":  "Debug",
      "ServerUrl":  "http://myapmserver:8200",
      "SecretToken":  "apm-server-secret-token",
      "TransactionSampleRate": 1.0
    }
}
```