﻿---
title: Supportability configuration options
description: dynamic config  Sets the logging level for the agent. Valid options: Critical, Error, Warning, Info, Debug, Trace and None (None disables the logging)...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/config-supportability
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# Supportability configuration options
## `LogLevel`

[![dynamic config](https://www.elastic.co/docs/reference/apm/agents/dotnet/images/dynamic-config.svg) ](/docs/reference/apm/agents/dotnet/configuration#dynamic-configuration)
Sets the logging level for the agent.
Valid options: `Critical`, `Error`, `Warning`, `Info`, `Debug`, `Trace` and `None` (`None` disables the logging).
<important>
  The `AddElasticApm()` extension enables configuration, as is typical in an ASP.NET Core application. You must instead set the `LogLevel` for the internal APM logger under the `Logging` section of `appsettings.json`. More details, including a [sample configuration file](/docs/reference/apm/agents/dotnet/configuration-on-asp-net-core#sample-config) are available in [Configuration on ASP.NET Core](https://www.elastic.co/docs/reference/apm/agents/dotnet/configuration-on-asp-net-core).
</important>


| Environment variable name | IConfiguration or Web.config key |
|---------------------------|----------------------------------|
| `OTEL_LOG_LEVEL`          | `ElasticApm:LogLevel`            |


| Default | Type   |
|---------|--------|
| `Error` | String |

<note>
  Although prefixed with `OTEL_` we prefer `OTEL_LOG_LEVEL`, when present as this aligns with the configuration for EDOT .NET and OpenTelemetry SDKs, simplifying migrations.
</note>