﻿---
title: All options summary
description: 
url: https://www.elastic.co/docs/reference/apm/agents/dotnet/config-all-options-summary
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# All options summary
| Option name                                                                                                                              | [![dynamic config](https://www.elastic.co/docs/reference/apm/agents/dotnet/images/dynamic-config.svg) ](/docs/reference/apm/agents/dotnet/configuration#dynamic-configuration) | Keywords                |
|------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------|
| [`ApiKey`](/docs/reference/apm/agents/dotnet/config-reporter#config-api-key)                                                             | No                                                                                                                                                                             | Reporter                |
| [`ApplicationNamespaces`](/docs/reference/apm/agents/dotnet/config-stacktrace#config-application-namespaces)                             | No                                                                                                                                                                             | Stacktrace              |
| [`CaptureBody`](/docs/reference/apm/agents/dotnet/config-http#config-capture-body)                                                       | Yes                                                                                                                                                                            | HTTP, Performance       |
| [`CaptureBodyContentTypes`](/docs/reference/apm/agents/dotnet/config-http#config-capture-body-content-types)                             | Yes                                                                                                                                                                            | HTTP, Performance       |
| [`CaptureHeaders`](/docs/reference/apm/agents/dotnet/config-http#config-capture-headers)                                                 | Yes                                                                                                                                                                            | HTTP, Performance       |
| [`CentralConfig`](/docs/reference/apm/agents/dotnet/config-core#config-central-config)                                                   | No                                                                                                                                                                             | Core                    |
| [`CloudProvider`](/docs/reference/apm/agents/dotnet/config-reporter#config-cloud-provider)                                               | No                                                                                                                                                                             | Reporter                |
| [`DisableMetrics`](/docs/reference/apm/agents/dotnet/config-reporter#config-disable-metrics)                                             | No                                                                                                                                                                             | Reporter                |
| [`Enabled`](/docs/reference/apm/agents/dotnet/config-core#config-enabled)                                                                | No                                                                                                                                                                             | Core                    |
| [`OpentelemetryBridgeEnabled`](/docs/reference/apm/agents/dotnet/config-core#config-opentelemetry-bridge-enabled)                        | No                                                                                                                                                                             | Core                    |
| [`Environment`](/docs/reference/apm/agents/dotnet/config-core#config-environment)                                                        | No                                                                                                                                                                             | Core                    |
| [`ExcludedNamespaces`](/docs/reference/apm/agents/dotnet/config-stacktrace#config-excluded-namespaces)                                   | No                                                                                                                                                                             | Stacktrace              |
| [`ExitSpanMinDuration`](/docs/reference/apm/agents/dotnet/config-core#config-exit-span-min-duration)                                     | Yes                                                                                                                                                                            | Core, Performance       |
| [`FlushInterval`](/docs/reference/apm/agents/dotnet/config-reporter#config-flush-interval)                                               | No                                                                                                                                                                             | Reporter                |
| [`GlobalLabels`](/docs/reference/apm/agents/dotnet/config-core#config-global-labels)                                                     | No                                                                                                                                                                             | Core                    |
| [`IgnoreMessageQueues`](/docs/reference/apm/agents/dotnet/config-messaging#config-ignore-message-queues)                                 | Yes                                                                                                                                                                            | Messaging, Performance  |
| [`HostName`](/docs/reference/apm/agents/dotnet/config-core#config-hostname)                                                              | No                                                                                                                                                                             | Core                    |
| [`LogLevel`](/docs/reference/apm/agents/dotnet/config-supportability#config-log-level)                                                   | Yes                                                                                                                                                                            | Supportability          |
| [`MaxBatchEventCount`](/docs/reference/apm/agents/dotnet/config-reporter#config-max-batch-event-count)                                   | No                                                                                                                                                                             | Reporter                |
| [`MaxQueueEventCount`](/docs/reference/apm/agents/dotnet/config-reporter#config-max-queue-event-count)                                   | No                                                                                                                                                                             | Reporter                |
| [`MetricsInterval`](/docs/reference/apm/agents/dotnet/config-reporter#config-metrics-interval)                                           | No                                                                                                                                                                             | Reporter                |
| [`Recording`](/docs/reference/apm/agents/dotnet/config-core#config-recording)                                                            | Yes                                                                                                                                                                            | Core                    |
| [`SanitizeFieldNames`](/docs/reference/apm/agents/dotnet/config-core#config-sanitize-field-names)                                        | Yes                                                                                                                                                                            | Core                    |
| [`SecretToken`](/docs/reference/apm/agents/dotnet/config-reporter#config-secret-token)                                                   | No                                                                                                                                                                             | Reporter                |
| [`ServerCert`](/docs/reference/apm/agents/dotnet/config-reporter#config-server-cert)                                                     | No                                                                                                                                                                             | Reporter                |
| [`ServerUrl`](/docs/reference/apm/agents/dotnet/config-reporter#config-server-url)                                                       | No                                                                                                                                                                             | Reporter                |
| [`ServiceName`](/docs/reference/apm/agents/dotnet/config-core#config-service-name)                                                       | No                                                                                                                                                                             | Core                    |
| [`ServiceNodeName`](/docs/reference/apm/agents/dotnet/config-core#config-service-node-name)                                              | No                                                                                                                                                                             | Core                    |
| [`ServiceVersion`](/docs/reference/apm/agents/dotnet/config-core#config-service-version)                                                 | No                                                                                                                                                                             | Core                    |
| [`SpanCompressionEnabled`](/docs/reference/apm/agents/dotnet/config-core#config-span-compression-enabled)                                | Yes                                                                                                                                                                            | Core, Performance       |
| [`SpanCompressionExactMatchMaxDuration`](/docs/reference/apm/agents/dotnet/config-core#config-span-compression-exact-match-max-duration) | Yes                                                                                                                                                                            | Core, Performance       |
| [`SpanCompressionSameKindMaxDuration`](/docs/reference/apm/agents/dotnet/config-core#config-span-compression-same-kind-max-duration)     | Yes                                                                                                                                                                            | Core, Performance       |
| [`SpanStackTraceMinDuration`](/docs/reference/apm/agents/dotnet/config-stacktrace#config-span-stack-trace-min-duration)                  | Yes                                                                                                                                                                            | Stacktrace, Performance |
| [`StackTraceLimit`](/docs/reference/apm/agents/dotnet/config-stacktrace#config-stack-trace-limit)                                        | Yes                                                                                                                                                                            | Stacktrace, Performance |
| [`TraceContextIgnoreSampledFalse`](/docs/reference/apm/agents/dotnet/config-http#config-trace-context-ignore-sampled-false)              | No                                                                                                                                                                             | Core                    |
| [`TransactionIgnoreUrls`](/docs/reference/apm/agents/dotnet/config-http#config-transaction-ignore-urls)                                  | Yes                                                                                                                                                                            | HTTP, Performance       |
| [`TransactionNameGroups`](/docs/reference/apm/agents/dotnet/config-http#config-transaction-name-groups)                                  | Yes                                                                                                                                                                            | HTTP                    |
| [`TransactionMaxSpans`](/docs/reference/apm/agents/dotnet/config-core#config-transaction-max-spans)                                      | Yes                                                                                                                                                                            | Core, Performance       |
| [`TransactionSampleRate`](/docs/reference/apm/agents/dotnet/config-core#config-transaction-sample-rate)                                  | Yes                                                                                                                                                                            | Core, Performance       |
| [`TraceContinuationStrategy`](/docs/reference/apm/agents/dotnet/config-http#config-trace-continuation-strategy)                          | Yes                                                                                                                                                                            | HTTP, Performance       |
| [`UseElasticTraceparentHeader`](/docs/reference/apm/agents/dotnet/config-http#config-use-elastic-apm-traceparent-header)                 | No                                                                                                                                                                             | HTTP                    |
| [`UsePathAsTransactionName`](/docs/reference/apm/agents/dotnet/config-http#config-use-path-as-transaction-name)                          | Yes                                                                                                                                                                            | HTTP                    |
| [`UseWindowsCredentials`](/docs/reference/apm/agents/dotnet/config-http#config-use-windows-credentials)                                  | No                                                                                                                                                                             | Reporter                |
| [`VerifyServerCert`](/docs/reference/apm/agents/dotnet/config-reporter#config-verify-server-cert)                                        | No                                                                                                                                                                             | Reporter                |
| [`ProxyUrl`](/docs/reference/apm/agents/dotnet/config-http#add-proxy-apm)                                                                | No                                                                                                                                                                             | HTTP                    |
| [`ProxyUserName`](/docs/reference/apm/agents/dotnet/config-http#add-proxy-apm)                                                           | No                                                                                                                                                                             | HTTP                    |
| [`ProxyPassword`](/docs/reference/apm/agents/dotnet/config-http#add-proxy-apm)                                                           | No                                                                                                                                                                             | HTTP                    |