﻿---
title: APM .NET agent
description: The Elastic APM .NET Agent automatically measures the performance of your application and tracks errors. It has built-in support for the most popular...
url: https://www.elastic.co/docs/reference/apm/agents/dotnet
products:
  - APM .NET Agent
  - APM Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for .NET: Generally available
---

# APM .NET agent
The Elastic APM .NET Agent automatically measures the performance of your application and tracks errors. It has built-in support for the most popular frameworks, as well as a simple API which allows you to instrument any application.

## How does the Agent work?

The agent auto-instruments [supported technologies](https://www.elastic.co/docs/reference/apm/agents/dotnet/supported-technologies) and records interesting events, like HTTP requests and database queries. To do this, it uses built-in capabilities of the instrumented frameworks like [Diagnostic Source](https://docs.microsoft.com/dotnet/api/system.diagnostics.diagnosticsource), an HTTP module for IIS, or [IDbCommandInterceptor](https://docs.microsoft.com/dotnet/api/system.data.entity.infrastructure.interception.idbcommandinterceptor?view=entity-framework-6.2.0) for Entity Framework. This means that for the supported technologies, there are no code changes required beyond enabling [auto-instrumentation](https://www.elastic.co/docs/reference/apm/agents/dotnet/set-up-apm-net-agent).
The Agent automatically registers callback methods for built-in Diagnostic Source events. With this, the supported frameworks trigger Agent code for relevant events to measure their duration and collect metadata, like DB statements, as well as HTTP related information, like the URL, parameters, and headers. These events, called Transactions and Spans, are sent to the APM Server. The APM Server converts them to a format suitable for Elasticsearch, and sends them to an Elasticsearch cluster. You can then use the APM app in Kibana to gain insight into latency issues and error culprits within your application.

## Additional Components

APM Agents work in conjunction with the [APM Server](https://www.elastic.co/docs/solutions/observability/apm), [Elasticsearch](https://www.elastic.co/docs/get-started), and [Kibana](https://www.elastic.co/docs/get-started/the-stack). The [APM Guide](https://www.elastic.co/docs/solutions/observability/apm) provides details on how these components work together, and provides a matrix outlining [Agent and Server compatibility](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility).

## Troubleshooting

If you're experiencing issues with the APM .NET agent, refer to [Troubleshoot APM .NET Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-dotnet/apm-net-agent).