﻿---
title: Inference bucket aggregation
description: A parent pipeline aggregation which loads a pre-trained model and performs inference on the collated result fields from the parent bucket aggregation...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-pipeline-inference-bucket-aggregation
products:
  - Elasticsearch
---

# Inference bucket aggregation
A parent pipeline aggregation which loads a pre-trained model and performs inference on the collated result fields from the parent bucket aggregation.
To use the inference bucket aggregation, you need to have the same security privileges that are required for using the [get trained models API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-trained-models).

## Syntax

A `inference` aggregation looks like this in isolation:
```js
{
  "inference": {
    "model_id": "a_model_for_inference", 
    "inference_config": { 
      "regression_config": {
        "num_top_feature_importance_values": 2
      }
    },
    "buckets_path": {
      "avg_cost": "avg_agg", 
      "max_cost": "max_agg"
    }
  }
}
```



| Parameter Name     | Description                                                                                                                                                                                                                 | Required | Default Value |
|--------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|---------------|
| `model_id`         | The ID or alias for the trained model.                                                                                                                                                                                      | Required | -             |
| `inference_config` | Contains the inference type and its options. There are two types: [`regression`](#inference-agg-regression-opt) and [`classification`](#inference-agg-classification-opt)                                                   | Optional | -             |
| `buckets_path`     | Defines the paths to the input aggregations and maps the aggregation names to the field names expected by the model.See [`buckets_path` Syntax](/docs/reference/aggregations/pipeline#buckets-path-syntax) for more details | Required | -             |


## Configuration options for inference models

The `inference_config` setting is optional and usually isn’t required as the pre-trained models come equipped with sensible defaults. In the context of aggregations some options can be overridden for each of the two types of model.

#### Configuration options for regression models

<definitions>
  <definition term="num_top_feature_importance_values">
    (Optional, integer) Specifies the maximum number of [feature importance](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-feature-importance) values per document. By default, it is zero and no feature importance calculation occurs.
  </definition>
</definitions>


#### Configuration options for classification models

<definitions>
  <definition term="num_top_classes">
    (Optional, integer) Specifies the number of top class predictions to return. Defaults to 0.
  </definition>
  <definition term="num_top_feature_importance_values">
    (Optional, integer) Specifies the maximum number of [feature importance](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-feature-importance) values per document. Defaults to 0 which means no feature importance calculation occurs.
  </definition>
  <definition term="prediction_field_type">
    (Optional, string) Specifies the type of the predicted field to write. Valid values are: `string`, `number`, `boolean`. When `boolean` is provided `1.0` is transformed to `true` and `0.0` to `false`.
  </definition>
</definitions>


## Example

The following snippet aggregates a web log by `client_ip` and extracts a number of features via metric and bucket sub-aggregations as input to the inference aggregation configured with a model trained to identify suspicious client IPs:
```json

{
  "size": 0,
  "aggs": {
    "client_ip": { <1>
      "composite": {
        "sources": [
          {
            "client_ip": {
              "terms": {
                "field": "clientip"
              }
            }
          }
        ]
      },
      "aggs": { <2>
        "url_dc": {
          "cardinality": {
            "field": "url.keyword"
          }
        },
        "bytes_sum": {
          "sum": {
            "field": "bytes"
          }
        },
        "geo_src_dc": {
          "cardinality": {
            "field": "geo.src"
          }
        },
        "geo_dest_dc": {
          "cardinality": {
            "field": "geo.dest"
          }
        },
        "responses_total": {
          "value_count": {
            "field": "timestamp"
          }
        },
        "success": {
          "filter": {
            "term": {
              "response": "200"
            }
          }
        },
        "error404": {
          "filter": {
            "term": {
              "response": "404"
            }
          }
        },
        "error503": {
          "filter": {
            "term": {
              "response": "503"
            }
          }
        },
        "malicious_client_ip": { <3>
          "inference": {
            "model_id": "malicious_clients_model",
            "buckets_path": {
              "response_count": "responses_total",
              "url_dc": "url_dc",
              "bytes_sum": "bytes_sum",
              "geo_src_dc": "geo_src_dc",
              "geo_dest_dc": "geo_dest_dc",
              "success": "success._count",
              "error404": "error404._count",
              "error503": "error503._count"
            }
          }
        }
      }
    }
  }
}
```