﻿---
title: Average bucket aggregation
description: A sibling pipeline aggregation which calculates the mean value of a specified metric in a sibling aggregation. The specified metric must be numeric and...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-pipeline-avg-bucket-aggregation
products:
  - Elasticsearch
---

# Average bucket aggregation
A sibling pipeline aggregation which calculates the mean value of a specified metric in a sibling aggregation. The specified metric must be numeric and the sibling aggregation must be a multi-bucket aggregation.

## Syntax

```js
"avg_bucket": {
  "buckets_path": "sales_per_month>sales",
  "gap_policy": "skip",
  "format": "#,##0.00;(#,##0.00)"
}
```


## Parameters

<definitions>
  <definition term="buckets_path">
    (Required, string) Path to the buckets to average. For syntax, see [`buckets_path` Syntax](/docs/reference/aggregations/pipeline#buckets-path-syntax).
  </definition>
  <definition term="gap_policy">
    (Optional, string) Policy to apply when gaps are found in the data. For valid values, see [Dealing with gaps in the data](/docs/reference/aggregations/pipeline#gap-policy). Defaults to `skip`.
  </definition>
  <definition term="format">
    (Optional, string) [DecimalFormat pattern](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/text/DecimalFormat.html) for the output value. If specified, the formatted value is returned in the aggregation’s `value_as_string` property.
  </definition>
</definitions>


## Response body

<definitions>
  <definition term="value">
    (float) Mean average value for the metric specified in `buckets_path`.
  </definition>
  <definition term="value_as_string">
    (string) Formatted output value for the aggregation. This property is only provided if a `format` is specified in the request.
  </definition>
</definitions>


## Example

The following `avg_monthly_sales` aggregation uses `avg_bucket` to calculate average sales per month:
```json

{
  "size": 0,
  "aggs": {
    "sales_per_month": {
      "date_histogram": {
        "field": "date",
        "calendar_interval": "month"
      },
      "aggs": {
        "sales": {
          "sum": {
            "field": "price"
          }
        }
      }
    },
    "avg_monthly_sales": {
// tag::avg-bucket-agg-syntax[]               <1>
      "avg_bucket": {
        "buckets_path": "sales_per_month>sales",
        "gap_policy": "skip",
        "format": "#,##0.00;(#,##0.00)"
      }
// end::avg-bucket-agg-syntax[]               <2>
    }
  }
}
```

The request returns the following response:
```json
{
  "took": 11,
  "timed_out": false,
  "_shards": ...,
  "hits": ...,
  "aggregations": {
    "sales_per_month": {
      "buckets": [
        {
          "key_as_string": "2015/01/01 00:00:00",
          "key": 1420070400000,
          "doc_count": 3,
          "sales": {
            "value": 550.0
          }
        },
        {
          "key_as_string": "2015/02/01 00:00:00",
          "key": 1422748800000,
          "doc_count": 2,
          "sales": {
            "value": 60.0
          }
        },
        {
          "key_as_string": "2015/03/01 00:00:00",
          "key": 1425168000000,
          "doc_count": 2,
          "sales": {
            "value": 375.0
          }
        }
      ]
    },
    "avg_monthly_sales": {
      "value": 328.33333333333333,
      "value_as_string": "328.33"
    }
  }
}
```