﻿---
title: T-test aggregation
description: A t_test metrics aggregation that performs a statistical hypothesis test in which the test statistic follows a Student’s t-distribution under the null...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-ttest-aggregation
products:
  - Elasticsearch
---

# T-test aggregation
A `t_test` metrics aggregation that performs a statistical hypothesis test in which the test statistic follows a Student’s t-distribution under the null hypothesis on numeric values extracted from the aggregated documents. In practice, this will tell you if the difference between two population means are statistically significant and did not occur by chance alone.

## Syntax

A `t_test` aggregation looks like this in isolation:
```js
{
  "t_test": {
    "a": "value_before",
    "b": "value_after",
    "type": "paired"
  }
}
```

Assuming that we have a record of node start up times before and after upgrade, let’s look at a t-test to see if upgrade affected the node start up time in a meaningful way.
```json

{
  "size": 0,
  "aggs": {
    "startup_time_ttest": {
      "t_test": {
        "a": { "field": "startup_time_before" },  <1>
        "b": { "field": "startup_time_after" },   <2>
        "type": "paired"                          <3>
      }
    }
  }
}
```

The response will return the p-value or probability value for the test. It is the probability of obtaining results at least as extreme as the result processed by the aggregation, assuming that the null hypothesis is correct (which means there is no difference between population means). Smaller p-value means the null hypothesis is more likely to be incorrect and population means are indeed different.
```json
{
  ...

 "aggregations": {
    "startup_time_ttest": {
      "value": 0.1914368843365979 
    }
  }
}
```


## T-Test Types

The `t_test` aggregation supports unpaired and paired two-sample t-tests. The type of the test can be specified using the `type` parameter:
<definitions>
  <definition term=""type": "paired"">
    performs paired t-test
  </definition>
  <definition term=""type": "homoscedastic"">
    performs two-sample equal variance test
  </definition>
  <definition term=""type": "heteroscedastic"">
    performs two-sample unequal variance test (this is default)
  </definition>
</definitions>


## Filters

It is also possible to run unpaired t-test on different sets of records using filters. For example, if we want to test the difference of startup times before upgrade between two different groups of nodes, we use the same field `startup_time_before` by separate groups of nodes using terms filters on the group name field:
```json

{
  "size": 0,
  "aggs": {
    "startup_time_ttest": {
      "t_test": {
        "a": {
          "field": "startup_time_before",         <1>
          "filter": {
            "term": {
              "group": "A"                        <2>
            }
          }
        },
        "b": {
          "field": "startup_time_before",         <3>
          "filter": {
            "term": {
              "group": "B"                        <4>
            }
          }
        },
        "type": "heteroscedastic"                 <5>
      }
    }
  }
}
```

```json
{
  ...

 "aggregations": {
    "startup_time_ttest": {
      "value": 0.2981858007281437 
    }
  }
}
```

Populations don’t have to be in the same index. If data sets are located in different indices, the term filter on the [`_index`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index-field) field can be used to select populations.

## Script

If you need to run the `t_test` on values that aren’t represented cleanly by a field you should, run the aggregation on a [runtime field](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields). For example, if you want to adjust out load times for the before values:
```json

{
  "size": 0,
  "runtime_mappings": {
    "startup_time_before.adjusted": {
      "type": "long",
      "script": {
        "source": "emit(doc['startup_time_before'].value - params.adjustment)",
        "params": {
          "adjustment": 10
        }
      }
    }
  },
  "aggs": {
    "startup_time_ttest": {
      "t_test": {
        "a": {
          "field": "startup_time_before.adjusted"
        },
        "b": {
          "field": "startup_time_after"
        },
        "type": "paired"
      }
    }
  }
}
```