﻿---
title: Stats aggregation
description: A multi-value metrics aggregation that computes stats over numeric values extracted from the aggregated documents. The stats that are returned consist...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-stats-aggregation
products:
  - Elasticsearch
---

# Stats aggregation
A `multi-value` metrics aggregation that computes stats over numeric values extracted from the aggregated documents.
The stats that are returned consist of: `min`, `max`, `sum`, `count` and `avg`.
Assuming the data consists of documents representing exams grades (between 0 and 100) of students
```json

{
  "aggs": {
    "grades_stats": { "stats": { "field": "grade" } }
  }
}
```

The above aggregation computes the grades statistics over all documents. The aggregation type is `stats` and the `field` setting defines the numeric field of the documents the stats will be computed on. The above will return the following:
```json
{
  ...

  "aggregations": {
    "grades_stats": {
      "count": 2,
      "min": 50.0,
      "max": 100.0,
      "avg": 75.0,
      "sum": 150.0
    }
  }
}
```

The name of the aggregation (`grades_stats` above) also serves as the key by which the aggregation result can be retrieved from the returned response.

## Script

If you need to get the `stats` for something more complex than a single field, run the aggregation on a [runtime field](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields).
```json

{
  "size": 0,
  "runtime_mappings": {
    "grade.weighted": {
      "type": "double",
      "script": """
        emit(doc['grade'].value * doc['weight'].value)
      """
    }
  },
  "aggs": {
    "grades_stats": {
      "stats": {
        "field": "grade.weighted"
      }
    }
  }
}
```


## Missing value

The `missing` parameter defines how documents that are missing a value should be treated. By default they will be ignored but it is also possible to treat them as if they had a value.
```json

{
  "aggs": {
    "grades_stats": {
      "stats": {
        "field": "grade",
        "missing": 0      <1>
      }
    }
  }
}
```