﻿---
title: Max aggregation
description: A single-value metrics aggregation that keeps track and returns the maximum value among the numeric values extracted from the aggregated documents. Computing...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-max-aggregation
products:
  - Elasticsearch
---

# Max aggregation
A `single-value` metrics aggregation that keeps track and returns the maximum value among the numeric values extracted from the aggregated documents.
<note>
  The `min` and `max` aggregation operate on the `double` representation of the data. As a consequence, the result may be approximate when running on longs whose absolute value is greater than `2^53`.
</note>

Computing the max price value across all documents
```json

{
  "aggs": {
    "max_price": { "max": { "field": "price" } }
  }
}
```

Response:
```json
{
  ...
  "aggregations": {
      "max_price": {
          "value": 200.0
      }
  }
}
```

As can be seen, the name of the aggregation (`max_price` above) also serves as the key by which the aggregation result can be retrieved from the returned response.

## Script

If you need to get the `max` of something more complex than a single field, run an aggregation on a [runtime field](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields).
```json

{
  "size": 0,
  "runtime_mappings": {
    "price.adjusted": {
      "type": "double",
      "script": """
        double price = doc['price'].value;
        if (doc['promoted'].value) {
          price *= 0.8;
        }
        emit(price);
      """
    }
  },
  "aggs": {
    "max_price": {
      "max": { "field": "price.adjusted" }
    }
  }
}
```


## Missing value

The `missing` parameter defines how documents that are missing a value should be treated. By default they will be ignored but it is also possible to treat them as if they had a value.
```json

{
  "aggs" : {
      "grade_max" : {
          "max" : {
              "field" : "grade",
              "missing": 10       <1>
          }
      }
  }
}
```


## Histogram fields

When `max` is computed on [histogram fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/histogram), the result of the aggregation is the maximum of all elements in the `values` array. Note, that the `counts` array of the histogram is ignored.
For example, for the following index that stores pre-aggregated histograms with latency metrics for different networks:
```json

{
  "mappings": {
    "properties": {
      "latency_histo": { "type": "histogram" }
    }
  }
}


{
  "network.name" : "net-1",
  "latency_histo" : {
      "values" : [0.1, 0.2, 0.3, 0.4, 0.5],
      "counts" : [3, 7, 23, 12, 6]
   }
}


{
  "network.name" : "net-2",
  "latency_histo" : {
      "values" :  [0.1, 0.2, 0.3, 0.4, 0.5],
      "counts" : [8, 17, 8, 7, 6]
   }
}


{
  "aggs" : {
    "max_latency" : { "max" : { "field" : "latency_histo" } }
  }
}
```

The `max` aggregation will return the maximum value of all histogram fields:
```json
{
  "aggregations": {
    "max_latency": {
      "value": 0.5
    }
  }
}
```