﻿---
title: Cartesian-bounds aggregation
description: A metric aggregation that computes the spatial bounding box containing all values for a Point or Shape field. Example: The above aggregation demonstrates...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-cartesian-bounds-aggregation
products:
  - Elasticsearch
---

# Cartesian-bounds aggregation
A metric aggregation that computes the spatial bounding box containing all values for a [Point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/point) or [Shape](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/shape) field.
Example:
```json

{
  "mappings": {
    "properties": {
      "location": {
        "type": "point"
      }
    }
  }
}


{"index":{"_id":1}}
{"location": "POINT (491.2350 5237.4081)", "city": "Amsterdam", "name": "NEMO Science Museum"}
{"index":{"_id":2}}
{"location": "POINT (490.1618 5236.9219)", "city": "Amsterdam", "name": "Museum Het Rembrandthuis"}
{"index":{"_id":3}}
{"location": "POINT (491.4722 5237.1667)", "city": "Amsterdam", "name": "Nederlands Scheepvaartmuseum"}
{"index":{"_id":4}}
{"location": "POINT (440.5200 5122.2900)", "city": "Antwerp", "name": "Letterenhuis"}
{"index":{"_id":5}}
{"location": "POINT (233.6389 4886.1111)", "city": "Paris", "name": "Musée du Louvre"}
{"index":{"_id":6}}
{"location": "POINT (232.7000 4886.0000)", "city": "Paris", "name": "Musée d'Orsay"}


{
  "query": {
    "match": { "name": "musée" }
  },
  "aggs": {
    "viewport": {
      "cartesian_bounds": {
        "field": "location"    <1>
      }
    }
  }
}
```

<note>
  Unlike the case with the [`geo_bounds`](/docs/reference/aggregations/search-aggregations-metrics-geobounds-aggregation#geobounds-aggregation-geo-shape) aggregation, there is no option to set [`wrap_longitude`](/docs/reference/aggregations/search-aggregations-metrics-geobounds-aggregation#geo-bounds-wrap-longitude). This is because the cartesian space is euclidean and does not wrap back on itself. So the bounds will always have a minimum x value less than or equal to the maximum x value.
</note>

The above aggregation demonstrates how one would compute the bounding box of the location field for all documents with a name matching "musée".
The response for the above aggregation:
```json
{
  ...
  "aggregations": {
    "viewport": {
      "bounds": {
        "top_left": {
          "x": 232.6999969482422,
          "y": 4886.111328125
        },
        "bottom_right": {
          "x": 233.63890075683594,
          "y": 4886.0
        }
      }
    }
  }
}
```


## Cartesian Bounds Aggregation on `shape` fields

The Cartesian Bounds Aggregation is also supported on `cartesian_shape` fields.
Example:
```json

{
  "mappings": {
    "properties": {
      "geometry": {
        "type": "shape"
      }
    }
  }
}


{"index":{"_id":1}}
{"name": "NEMO Science Museum", "geometry": "POINT(491.2350 5237.4081)" }
{"index":{"_id":2}}
{"name": "Sportpark De Weeren", "geometry": { "type": "Polygon", "coordinates": [ [ [ 496.5305328369141, 5239.347642069457 ], [ 496.6979026794433, 5239.1721758934835 ], [ 496.9425201416015, 5239.238958618537 ], [ 496.7944622039794, 5239.420969150824 ], [ 496.5305328369141, 5239.347642069457 ] ] ] } }


{
  "aggs": {
    "viewport": {
      "cartesian_bounds": {
        "field": "geometry"
      }
    }
  }
}
```

```json
{
  ...
  "aggregations": {
    "viewport": {
      "bounds": {
        "top_left": {
          "x": 491.2349853515625,
          "y": 5239.4208984375
        },
        "bottom_right": {
          "x": 496.9425048828125,
          "y": 5237.408203125
        }
      }
    }
  }
}
```