﻿---
title: Change point aggregation
description: A sibling pipeline that detects, spikes, dips, and change points in a metric. Given a distribution of values provided by the sibling multi-bucket aggregation,...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-change-point-aggregation
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2, Preview from 9.0 to 9.1
---

# Change point aggregation
A sibling pipeline that detects, spikes, dips, and change points in a metric. Given a distribution of values provided by the sibling multi-bucket aggregation, this aggregation indicates the bucket of any spike or dip and/or the bucket at which the largest change in the distribution of values, if they are statistically significant.
<tip>
  It is recommended to use the change point aggregation to detect changes in time-based data, however, you can use any metric to create buckets.
</tip>


## Parameters

<definitions>
  <definition term="buckets_path">
    (Required, string) Path to the buckets that contain one set of values in which to detect a change point. There must be at least 22 bucketed values. Fewer than 1,000 is preferred. For syntax, see [`buckets_path` Syntax](/docs/reference/aggregations/pipeline#buckets-path-syntax).
  </definition>
</definitions>


## Syntax

A `change_point` aggregation looks like this in isolation:
```js
{
  "change_point": {
    "buckets_path": "date_histogram>_count" 
  }
}
```


## Response body

<definitions>
  <definition term="bucket">
    (Optional, object) Values of the bucket that indicates the discovered change point. Not returned if no change point was found. All the aggregations in the bucket are returned as well.
    **Properties of `bucket**:
    <definitions>
      <definition term="key">
        (value) The key of the bucket matched. Could be string or numeric.
      </definition>
      <definition term="doc_count">
        (number) The document count of the bucket.
      </definition>
    </definitions>
  </definition>
  <definition term="type">
    (object) The found change point type and its related values. Possible types:
    - `dip`: a significant dip occurs at this change point
    - `distribution_change`: the overall distribution of the values has changed significantly
    - `non_stationary`: there is no change point, but the values are not from a stationary distribution
    - `spike`: a significant spike occurs at this point
    - `stationary`: no change point found
    - `step_change`: the change indicates a statistically significant step up or down in value distribution
    - `trend_change`: there is an overall trend change occurring at this point
  </definition>
</definitions>


## Example

The following example uses the Kibana sample data logs data set.
```js
GET kibana_sample_data_logs/_search
{
  "aggs": {
    "date":{ 
      "date_histogram": {
        "field": "@timestamp",
        "fixed_interval": "1d"
      },
      "aggs": {
        "avg": { 
          "avg": {
            "field": "bytes"
          }
        }
      }
    },
    "change_points_avg": { 
      "change_point": {
        "buckets_path": "date>avg" 
      }
    }
  }
}
```

The request returns a response that is similar to the following:
```js
    "change_points_avg" : {
      "bucket" : {
        "key" : "2023-04-29T00:00:00.000Z", 
        "doc_count" : 329, 
        "avg" : { 
          "value" : 4737.209726443769
        }
      },
      "type" : { 
        "dip" : {
          "p_value" : 3.8999455212466465e-10, 
          "change_point" : 41 
        }
      }
    }
```