﻿---
title: Missing aggregation
description: A field data based single bucket aggregation, that creates a bucket of all documents in the current document set context that are missing a field value...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-missing-aggregation
products:
  - Elasticsearch
---

# Missing aggregation
A field data based single bucket aggregation, that creates a bucket of all documents in the current document set context that are missing a field value (effectively, missing a field or having the configured NULL value set). This aggregator will often be used in conjunction with other field data bucket aggregators (such as ranges) to return information for all the documents that could not be placed in any of the other buckets due to missing field data values.
Example:

```json

{
  "aggs": {
    "products_without_a_price": {
      "missing": { "field": "price" }
    }
  }
}
```

In the above example, we get the total number of products that do not have a price.
Response:
```json
{
  ...
  "aggregations": {
    "products_without_a_price": {
      "doc_count": 0
    }
  }
}
```