﻿---
title: Global aggregation
description: Defines a single bucket of all the documents within the search execution context. This context is defined by the indices and the document types you’re...
url: https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-global-aggregation
products:
  - Elasticsearch
---

# Global aggregation
Defines a single bucket of all the documents within the search execution context. This context is defined by the indices and the document types you’re searching on, but is **not** influenced by the search query itself.
<note>
  Global aggregators can only be placed as top level aggregators because it doesn’t make sense to embed a global aggregator within another bucket aggregator.
</note>

Example:

```json

{
  "query": {
    "match": { "type": "t-shirt" }
  },
  "aggs": {
    "all_products": {
      "global": {}, <1>
      "aggs": {     <2>
      "avg_price": { "avg": { "field": "price" } }
      }
    },
    "t_shirts": { "avg": { "field": "price" } }
  }
}
```

The above aggregation demonstrates how one would compute aggregations (`avg_price` in this example) on all the documents in the search context, regardless of the query (in our example, it will compute the average price over all products in our catalog, not just on the "shirts").
The response for the above aggregation:
```json
{
  ...
  "aggregations": {
    "all_products": {
      "doc_count": 7, 
      "avg_price": {
        "value": 140.71428571428572 
      }
    },
    "t_shirts": {
      "value": 128.33333333333334 
    }
  }
}
```