﻿---
title: Reference
description: Explore reference documentation for the Elastic Stack including APIs, security schemas, configuration settings, query languages, scripting, ECS field references, and more.
url: https://www.elastic.co/docs/reference
products:
  - Elastic Stack
---

# Reference
Explore the reference documentation for the Elastic Stack. Whether you are configuring security protocols, enhancing search functionalities, or integrating with cloud services, our detailed manuals, API guides, and configuration settings provide the information you need.

## APIs

Explore the reference documentation for [Elastic APIs](https://www.elastic.co/docs/api/).

|                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                             |
|------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Elasticsearch                                                                | • [Elasticsearch](https://www.elastic.co/docs/api/doc/elasticsearch/)• [Elasticsearch Serverless](https://www.elastic.co/docs/api/doc/elasticsearch-serverless/)                                                                                                                                                                                                                                                            |
| Kibana(Observability, Elastic Security, APM agent, Fleet, and more features) | • [Kibana](https://www.elastic.co/docs/api/doc/kibana/)• [Kibana Serverless](https://www.elastic.co/docs/api/doc/serverless/)                                                                                                                                                                                                                                                                                               |
| Logstash                                                                     | • [Logstash](https://www.elastic.co/docs/api/doc/logstash/)                                                                                                                                                                                                                                                                                                                                                                 |
| APM                                                                          | • [APM Server](https://www.elastic.co/docs/solutions/observability/apm/apm-server/api)• [Observability intake Serverless](https://www.elastic.co/docs/api/doc/observability-serverless/)                                                                                                                                                                                                                                    |
| Elastic Cloud                                                                | • [Elastic Cloud Hosted](https://www.elastic.co/docs/api/doc/cloud/)• [Elastic Cloud Serverless](https://www.elastic.co/docs/api/doc/elastic-cloud-serverless/)• [Elastic Cloud Enterprise](https://www.elastic.co/docs/api/doc/cloud-enterprise/)• [Elastic Cloud on Kubernetes](https://www.elastic.co/docs/reference/cloud-on-k8s/api-docs)• [Elastic Cloud billing](https://www.elastic.co/docs/api/doc/cloud-billing/) |


## Elasticsearch

Customize your Elastic Stack setup with our configuration reference guides. Explore JVM settings, client documentation, Elasticsearch privileges, and index lifecycle actions to find the detailed information you need to configure your environment to your specific needs.
**Learn more in [Elasticsearch and index management](https://www.elastic.co/docs/reference/elasticsearch)**

## Kibana

Visualize and analyze your data with Kibana. Configure advanced settings, explore plugins, and utilize command line tools to enhance your data insights.
**Learn more in [Kibana](https://www.elastic.co/docs/reference/kibana)**

## Cloud

Leverage the power of the cloud with Elastic Cloud solutions. Explore Elastic Cloud on Kubernetes, Elastic Cloud Enterprise, and Elastic Cloud Hosted to scale your operations.
**Learn more in [Cloud](https://www.elastic.co/docs/reference/cloud)**

## Elastic Security

Access detailed reference documentation on field and object schemas as well as the different commands used to manage and troubleshoot Elastic Endpoint.
**Learn more in [Security](https://www.elastic.co/docs/reference/security)**

## Elastic Observability

Access detailed reference documentation on field and object schemas as well as the Elastic Entity Model.
**Learn more in [Observability](https://www.elastic.co/docs/reference/observability)**

## Ingestion tools

Streamline data ingestion with tools like Fleet and Elastic Agent, APM, Beats, and Elastic Distributions of OpenTelemetry. Explore processor references and Logstash plugins to efficiently manage your data flow.
**Learn more in [Ingestion tools](https://www.elastic.co/docs/reference/ingestion-tools)**

## Elasticsearch plugins

Extend the functionality of your Elastic Stack with a variety of plugins. From analysis and discovery to snapshot/restore and store plugins, customize your setup to fit your requirements.
**Learn more in [Plugins](https://www.elastic.co/docs/reference/elasticsearch/plugins)**

## Query languages

Master data querying with our comprehensive guides on QueryDSL, ESQL, SQL, EQL, and Kibana Query Language.
**Learn more in [Query languages](https://www.elastic.co/docs/reference/query-languages)**

## Painless scripting language

Access syntax reference, function libraries, and best practices for Painless scripting.
**Learn more in [Painless scripting](https://www.elastic.co/docs/reference/scripting-languages/painless/painless)**

## ECS (Elastic Common Schema) reference

Standardize your data with ECS. Access logging libraries, field references, and categorization fields to ensure consistency and compatibility across your data sources.
**Learn more in [ECS](https://www.elastic.co/docs/reference/ecs)**

## Machine learning

Explore reference content for Elastic machine learning features.
**Learn more in [Machine learning](https://www.elastic.co/docs/reference/machine-learning)**

## Search UI library

Explore reference content on the Search UI library and how you can develop fast, modern, and engaging search experiences.
**Learn more in [Search UI](https://www.elastic.co/docs/reference/search-ui)**