﻿---
title: Migrate system indices
description: When you migrate your Elasticsearch data into a new infrastructure, you might also want to migrate system-level indices and data streams, such as those...
url: https://www.elastic.co/docs/manage-data/migrate/migrate-internal-indices
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Stack: Generally available
---

# Migrate system indices
When you migrate your Elasticsearch data into a new infrastructure, you might also want to migrate system-level indices and data streams, such as those used by Kibana or security features (for example, `.kibana` and `.security`).
Starting in Elasticsearch 8.0, you can use [feature states](/docs/deploy-manage/tools/snapshot-and-restore#feature-state) to back up and restore all system indices and system data streams. This is the only available method for migrating this type of data.
However, using snapshot and restore for system indices does not mean you must use it for everything. You can still migrate other data by re-indexing from the source or a remote cluster.

## Migrate system indices using snapshot and restore

To restore system indices from a snapshot, follow the same procedure described in [Migrate your Elasticsearch data > Restore from a snapshot](/docs/manage-data/migrate#ec-restore-snapshots) and select the appropriate feature states when preparing the restore operation, such as `kibana` or `security`.
For more details about restoring feature states, or the entire cluster state, refer to [Restore a snapshot > Restore a feature state](/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot#restore-feature-state).
The following example describes how to restore the `security` feature using the [restore snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-restore):
```sh
POST _snapshot/REPOSITORY/SNAPSHOT_NAME/_restore
{
  "indices": "-*",
  "ignore_unavailable": true,
  "include_global_state": false,
  "include_aliases": false,
  "feature_states": [
    "security"
  ]
}
```