﻿---
title: Migrating from rollups to downsampling in Elasticsearch
description: Understand how to transition from legacy rollup jobs to Elasticsearch downsampling. This documentation explains key differences between the two and outlines...
url: https://www.elastic.co/docs/manage-data/lifecycle/rollup/migrating-from-rollup-to-downsampling
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Migrating from rollups to downsampling in Elasticsearch
Understand how to transition from legacy rollup jobs to Elasticsearch downsampling. This documentation explains key differences between the two and outlines migration steps.
The following aspects of downsampling are easier or more robust than using rollup jobs:
- No need to schedule jobs. Downsampling is integrated with Index Lifecycle Management (ILM) and Data Stream Lifecycle (DSL).
- No separate search API. Downsampled indices can be accessed using the search API and ES|QL.
- No separate rollup configuration. Downsampling uses the time series dimension and metric configuration from the mapping.

It isn’t possible to migrate all rollup usages to downsampling. The main requirement is that the data should be stored in Elasticsearch as [time series data stream (TSDS)](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds). Rollup usages that basically roll the data up by time and all dimensions can migrate to downsampling.
An example rollup usage that can be migrated to downsampling:
```json

{
  "index_pattern": "sensor-*",
  "rollup_index": "sensor_rollup",
  "cron": "0 0 * * * *",
  "page_size": 1000,
  "groups": {
    "date_histogram": {
      "field": "timestamp",
      "fixed_interval": "60m"
    },
    "terms": {
      "fields": [ "node" ]
    }
  },
  "metrics": [
    {
      "field": "temperature",
      "metrics": [ "min", "max", "sum" ]
    },
    {
      "field": "voltage",
      "metrics": [ "avg" ]
    }
  ]
}
```

The equivalent [time series data stream (TSDS)](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds) setup that uses downsampling using DSL:
```json

{
  "index_patterns": ["sensor-*"],
  "data_stream": { },
  "template": {
    "lifecycle": {
        "downsampling": [
            {
                "after": "1d", <1>
                "fixed_interval": "1h" <3>
            }
        ]
    },
    "settings": {
      "index.mode": "time_series"
    },
    "mappings": {
      "properties": {
        "node": {
          "type": "keyword",
          "time_series_dimension": true <2>
        },
        "temperature": {
          "type": "half_float",
          "time_series_metric": "gauge" <4>
        },
        "voltage": {
          "type": "half_float",
          "time_series_metric": "gauge" <4>
        },
        "@timestamp": { <2>
          "type": "date"
        }
      }
    }
  }
}
```