﻿---
title: Manage time series data without data streams
description: Even though data streams are a convenient way to scale and manage time series data, they are designed to be append-only. We recognize there might be use-cases...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-time-series-without-data-streams
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Manage time series data without data streams
Even though [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams) are a convenient way to scale and manage time series data, they are designed to be append-only. We recognize there might be use-cases where data needs to be updated or deleted in place and the data streams don't support delete and update requests directly, so the index APIs would need to be used directly on the data stream's backing indices. In these cases we still recommend using a data stream.
If you frequently send multiple documents using the same `_id` expecting last-write-wins, you can use an index alias instead of a data stream to manage indices containing the time series data and periodically roll over to a new index.
To automate rollover and management of time series indices with ILM using an index alias, you:
1. [Create a lifecycle policy](#ilm-gs-create-policy) that defines the appropriate phases and actions.
2. [Create an index template](#ilm-gs-alias-apply-policy) to apply the policy to each new index.
3. [Bootstrap an index](#ilm-gs-alias-bootstrap) as the initial write index.
4. [Verify indices are moving through the lifecycle phases](#ilm-gs-alias-check-progress) as expected.


## Create a lifecycle policy

A lifecycle policy specifies the phases in the index lifecycle and the actions to perform in each phase. A lifecycle can have up to five phases: `hot`, `warm`, `cold`, `frozen`, and `delete`.
For example, you might define a policy named `timeseries_policy` that has the following two phases:
- A `hot` phase that defines a rollover action to specify that an index rolls over when it reaches either a `max_primary_shard_size` of 50 gigabytes or a `max_age` of 30 days.
- A `delete` phase that sets `min_age` to remove the index 90 days after rollover.

<note>
  The `min_age` value is relative to the rollover time, not the index creation time. [Learn more](/docs/troubleshoot/elasticsearch/index-lifecycle-management-errors#min-age-calculation).
</note>

You can create the policy in Kibana or with the [create or update policy](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-put-lifecycle) API.
<tab-set>
  <tab-item title="Kibana">
    To create the policy from Kibana:
    1. Go to the **Index Lifecycle Policies** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Click **Create policy**.
    By default, only the hot index lifecycle phase is enabled. Enable each additional lifecycle phase that you'd like.
    ![Create policy page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-create-policy.png)
  </tab-item>

  <tab-item title="API">
    Use the [Create or update policy](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-put-lifecycle) API to add an ILM policy to the Elasticsearch cluster:
    ```json

    {
      "policy": {
        "phases": {
          "hot": {                                <1>
            "actions": {
              "rollover": {
                "max_primary_shard_size": "50GB", <2>
                "max_age": "30d"
              }
            }
          },
          "delete": {
            "min_age": "90d",                     <3>
            "actions": {
              "delete": {}                        <4>
            }
          }
        }
      }
    }
    ```

    1. The `min_age` defaults to `0ms`, so new indices enter the `hot` phase immediately.
    2. Trigger the `rollover` action when either of the conditions are met.
    3. Move the index into the `delete` phase 90 days after rollover.
    4. Trigger the `delete` action when the index enters the delete phase.
  </tab-item>
</tab-set>

Note that for each phase after the hot phase, you have the option to move the data into the next phase after a certain duration of time. This duration is calculated from the time of the index rollover and not from the time the index is created.
<tip>
  For more details about default ILM policy settings, refer to [Create a lifecycle policy](/docs/manage-data/lifecycle/index-lifecycle-management/configure-lifecycle-policy#ilm-create-policy).
</tip>


## Create an index template to apply the lifecycle policy

To automatically apply a lifecycle policy to the new write index on rollover, specify the policy in the index template used to create new indices.
For example, you might create a `timeseries_template` that is applied to new indices whose names match the `timeseries-*` index pattern.
To enable automatic rollover, the template configures two ILM settings:
- `index.lifecycle.name` specifies the name of the lifecycle policy to apply to new indices that match the index pattern.
- `index.lifecycle.rollover_alias` specifies the index alias to be rolled over when the rollover action is triggered for an index.

<tab-set>
  <tab-item title="Kibana">
    To use the Kibana **Create template** wizard to add the template:
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. In the **Index Templates** tab, click **Create template**.
    ![Create template page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-create-template-wizard.png)
    <tip>
      For more information about the available index template options that you can specify, refer to [Create an index template to apply the lifecycle policy](/docs/manage-data/lifecycle/index-lifecycle-management/configure-lifecycle-policy#apply-policy-template).
    </tip>
  </tab-item>

  <tab-item title="API">
    The create template request for the example template looks like this:
    ```json

    {
      "index_patterns": ["timeseries-*"],                 <1>
      "template": {
        "settings": {
          "number_of_shards": 1,
          "number_of_replicas": 1,
          "index.lifecycle.name": "timeseries_policy",      <2>
          "index.lifecycle.rollover_alias": "timeseries"    <3>
        }
      }
    }
    ```
  </tab-item>
</tab-set>


## Bootstrap the initial time series index with a write index alias

To get things started, you need to bootstrap an initial index and designate it as the write index for the rollover alias specified in your index template. The name of this index must match the template’s index pattern and end with a number. On rollover, this value is incremented to generate a name for the new index.
For example, the following request creates an index called `timeseries-000001` and makes it the write index for the `timeseries` alias.
```json

{
  "aliases": {
    "timeseries": {
      "is_write_index": true
    }
  }
}
```

When the rollover conditions are met, the `rollover` action:
- Creates a new index called `timeseries-000002`. This matches the `timeseries-*` pattern, so the settings from `timeseries_template` are applied to the new index.
- Designates the new index as the write index and makes the bootstrap index read-only.

This process repeats each time rollover conditions are met. You can search across all of the indices managed by the `timeseries_policy` with the `timeseries` alias. Write operations should be sent towards the alias, which will route them to its current write index.

## Check lifecycle progress

Retrieving the status information for managed indices is very similar to the case of [managing time series data with data streams](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-time-series-with-data-streams) case, the only difference being the indices namespace. Run the following API request to retrieve the lifecycle progress:
```json
```

See [Check lifecycle progress](/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-time-series-with-data-streams#ilm-gs-check-progress) for more information.