﻿---
title: Customize built-in ILM policies in Elasticsearch
description: Elasticsearch includes several built-in index lifecycle management (ILM) policies to help manage your logs and metrics efficiently. This tutorial shows...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-customize-built-in-policies
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Customize built-in ILM policies in Elasticsearch
Elasticsearch includes several built-in index lifecycle management (ILM) policies to help manage your logs and metrics efficiently. This tutorial shows you how to safely duplicate and customize these policies to optimize [rollover](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/rollover) and other [actions](/docs/manage-data/lifecycle/index-lifecycle-management/index-lifecycle#ilm-phase-actions), control resource usage across hot and warm [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers), and enforce retention rules for your indices.
Follow these steps to create a customized copy of a built-in ILM policy. You should never edit managed policies directly, because updates to Elasticsearch or Elastic integrations might overwrite those changes. Instead, you can duplicate a built-in policy, modify the duplicate, and assign it to your index or component templates.
While this tutorial uses [Elastic Agent](https://www.elastic.co/docs/reference/fleet) and its built-in `logs@lifecycle` policy as an example, the same process can be applied to any built-in policies. Common examples include:
- `logs@lifecycle`
- `logs-otel@lifecycle`
- `metrics@lifecycle`
- `metrics-otel@lifecycle`
- `synthetics@lifecycle`
- `traces@lifecycle`
- `traces-otel@lifecycle`

Customizing an ILM policy is useful when you have specific data retention or rollover requirements. For example, large log or metrics data streams might need different retention periods than the built-in defaults.
<important applies-to="Elastic Stack: Generally available since 9.3">
  In Elastic Stack 9.3 and later, the deprecated `logs`, `metrics`, and `synthetics` ILM policies are replaced by functionally equivalent `{type}@lifecycle` policies to align with the naming conventions for other stack-managed assets.If both the deprecated ILM policy and its `{type}@lifecycle` replacement haven’t been modified, Fleet automatically migrates component templates that still reference the deprecated ILM policy.If either managed ILM policy has been modified, you need to migrate the customizations manually. Follow this tutorial to create a self-managed ILM policy with your custom settings, and reference it from the relevant `{type}@custom` component template.
</important>

This tutorial covers customizing the way ingested logging data is managed. Rather than use the default lifecycle settings from the built-in `logs@lifecycle` ILM policy, you can use the **Index Lifecycle Policies** feature in Kibana to tailor a new policy based on your application’s specific performance, resilience, and retention requirements. You can adapt the same steps for any policy that manages your data streams.
The process involves three main steps:
1. [Create a duplicate of the `logs@lifecycle` policy](#example-using-index-lifecycle-policy-duplicate-ilm-policy).
2. [Modify the new policy to suit your requirements](#ilm-ex-modify-policy).
3. [Apply the new policy to your log data using a `logs@custom` component template](#example-using-index-lifecycle-policy-apply-policy).

Once applied, your customized policy will govern any new indices created after the change. Existing indices will continue to use their current lifecycle policy until they roll over. If you want the policy to take effect immediately, you can manually [roll over](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-rollover) the data stream.
<tip>
  - If you're using [Elastic integrations](https://docs.elastic.co/en/integrations) and are not yet familiar with which data streams are associated with them, refer to [Managing lifecycle polices for integrations data](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/manage-lifecycle-integrations-data).
  - If you're looking for a more advanced use case, such as customizing an ILM policy for a selected set of data streams in one or more integrations or namespaces, check the set of tutorials in [Tutorials: Customize data retention policies](https://www.elastic.co/docs/reference/fleet/data-streams-ilm-tutorial) in the Fleet and Elastic Agent reference documentation.
    These tutorials go into greater depth about creating and using `@custom` component templates. For example, the tutorial [Apply an ILM policy to all data streams generated from Fleet integrations across all namespaces](https://www.elastic.co/docs/reference/fleet/data-streams-scenario1) shows how to create and use the `logs@custom` and `metrics@custom` component templates to customize ILM policies associated with data streams in integrations.
</tip>


## Scenario

You want to send log files to an Elasticsearch cluster so you can visualize and analyze the data. This data has the following retention requirements:
- When the primary shard size of the write index reaches 50GB or the index is 30 days old, roll over to a new index.
- After rollover, keep indices in the hot data tier for 30 days.
- 30 days after rollover:
  - Move indices to the warm data tier.
- Set replica shards to 1.
- [Force merge](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-forcemerge) multiple index segments to free up the space used by deleted documents.
- Delete indices 90 days after rollover.


## Prerequisites

To complete this tutorial, you’ll need:
- An Elasticsearch cluster with hot and warm data tiers.
  - Elastic Cloud Hosted: Elastic Stack deployments on Elastic Cloud include a hot tier by default. To add a warm tier, edit your deployment and click **Add capacity** for the warm data tier.
  ![Add a warm data tier to your deployment](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-tutorial-ilm-ess-add-warm-data-tier.png)
- Self-managed cluster: Assign `data_hot` and `data_warm` roles to nodes as described in [*Data tiers*](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers).
  For example, include the `data_warm` node role in the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file of each node in the warm tier:
  ```yaml
  node.roles: [ data_warm ]
  ```
- A host with Elastic Agent installed and configured to send logs to your Elasticsearch cluster.


## Duplicate the policy

Elastic Agent uses data streams with an index pattern of `logs-*-*` to store log monitoring data. The managed `logs@lifecycle` ILM policy automatically manages backing indices for these data streams.
If you don’t want to use the policy defaults, then you can customize the managed policy and then save it as a new policy. You can then use the new policy in related component templates and index templates.
<warning>
  You should never edit managed policies directly. Changes to managed policies might be rolled back or overwritten.
</warning>

To save the `logs@lifecycle` policy as a new policy in Kibana:
1. Go to the **Index Lifecycle Policies** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Toggle **Include managed system policies**.
3. Select the `logs@lifecycle` policy.
4. On the **Edit policy logs** page, toggle **Save as new policy**, and then provide a new name for the policy, for example, `logs-custom`.

The `logs@lifecycle` policy uses the recommended rollover defaults: Start writing to a new index when the primary shard size of the current write index reaches 50GB or the index becomes 30 days old.
To view or change the rollover settings, click **Advanced settings** for the hot phase. Then disable **Use recommended defaults** to display the rollover settings.
![View rollover defaults](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-tutorial-ilm-hotphaserollover-default.png)


## Modify the policy

The default `logs@lifecycle` policy is designed to prevent the creation of many tiny daily indices. You can modify your copy of the policy to meet your performance requirements and manage resource usage.
1. Activate the warm phase and click **Advanced settings**.
   1. Set **Move data into phase when** to **30 days old**. This moves indices to the warm tier 30 days after rollover.
2. Enable **Set replicas** and change **Number of replicas** to **1**.
3. Enable **Force merge data** and set **Number of segments** to **1**.
   ![Add a warm phase with custom settings](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-tutorial-ilm-modify-default-warm-phase-rollover.png)
2. In the warm phase, click the trash icon to enable the delete phase.
   ![Enable the delete phase](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-tutorial-ilm-enable-delete-phase.png)
   In the delete phase, set **Move data into phase when** to **90 days old**. This deletes indices 90 days after rollover.
   ![Add a delete phase](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-tutorial-ilm-delete-rollover.png)
3. Click **Save as new policy**.

<tip>
  Copies of managed ILM policies are also marked as **Managed**. You can use the [Create or update lifecycle policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-put-lifecycle) to update the `_meta.managed` parameter to `false`.
</tip>


## Apply the policy

To apply your new ILM policy to the `logs` index template, create or edit the `logs@custom` component template.
<admonition title="Using @custom component templates">
  A `@custom` component template allows you to customize the mappings and settings of the managed index templates, without having to override them or their main component templates.Many Elasticsearch managed index templates include one or more `@custom` component templates. A `@custom` component template must first be created before it can be used, and its name must exactly match the name specified in the managed index template in order to be applied automatically to indices as they're created.For example, if you're ingesting OpenTelemetry (OTel) logs, any OTel log data streams and their backing indices are configured by the `logs-otel@template` managed index template. That index template automatically applies settings defined in the `logs@custom` and the `logs-otel@custom` template when they exist.Go to **Index Management > Index Templates** and select any managed index to view the `@custom` component templates associated with it.
  ![A screenshot showing the logs@custom and logs-otel@custom component templates associated with the logs-otel@template index template.](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-tutorial-custom-policies-otel-template.png)
</admonition>

<tip>
  If you want your ILM changes to apply only to specific indices, you can create a custom index template directly instead of modifying the custom component template. Use the **Index management** page in Kibana or the [index template](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-index-template) API to create a new template.
</tip>

1. Click on the **Component Template** tab and click **Create component template**.
2. Under **Logistics**, name the component template `logs@custom`.
3. Under **Index settings**, set the ILM policy name created in the previous step:
   ```JSON
   {
       "index": {
           "lifecycle": {
               "name": "logs-custom"
           }
       }
   }
   ```
4. Continue to **Review**, and then click **Save component template**.
5. Click the **Index Templates**, tab, and then select the `logs` index template.
6. In the summary, view the **Component templates** list. `logs@custom` should be listed.