﻿---
title: Start and stop index lifecycle management
description: By default, the ILM service is in a RUNNING state and manages all indices that have lifecycle policies. You can stop and restart the index lifecycle management...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/start-stop-index-lifecycle-management
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Start and stop index lifecycle management
By default, the ILM service is in a `RUNNING` state and manages all indices that have lifecycle policies. You can stop and restart the index lifecycle management service as needed.
Follow these steps to check the current ILM status, and to stop or restart it as needed.

### Get ILM status

To view the current status of the ILM service, use the [ILM status API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-get-status):
```json
```

Under normal operation, the response shows ILM is `RUNNING`:
```json
{
  "operation_mode": "RUNNING"
}
```

You can also [Check the ILM status of Elasticsearch indices and data streams](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-view-status) for further information.

### Stop ILM

By default, the index lifecycle management service is in the `RUNNING` state and manages all indices that have lifecycle policies.
You can stop ILM to suspend management operations for all indices. For example, you might stop index lifecycle management when performing scheduled maintenance or making changes to the cluster that could impact the execution of ILM actions.
<important>
  When you stop ILM, [SLM](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#automate-snapshots-slm) operations are also suspended. SLM will not take snapshots as scheduled until you restart ILM. In-progress snapshots are not affected.
</important>

To stop the ILM service and pause execution of all lifecycle policies, use the [ILM stop API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-stop):
```json
```

The response looks like this:
```json
{
  "acknowledged": true
}
```

The ILM service runs all policies to a point where it is safe to stop.
While the ILM service is shutting down, run the status API to verify that ILM is stopping:
```json
```

The response looks like this:
```json
{
  "operation_mode": "STOPPING"
}
```

Once all policies are at a safe stopping point, ILM moves into the `STOPPED` mode:
```json
{
  "operation_mode": "STOPPED"
}
```


### Start ILM

If the automatic index lifecycle management or snapshot lifecycle management service is not working, you might need to restart the service.
To restart ILM and resume executing policies, use the [ILM start API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-start). This puts the  ILM service in the `RUNNING` state and ILM begins executing policies from where it left off.
```json
```

The response looks like this:
```json
{
  "acknowledged": true
}
```

Verify that index lifecycle management is now running:
```json
```

The response looks like this:
```json
{
  "operation_mode": "RUNNING"
}
```