﻿---
title: Check the ILM status of Elasticsearch indices and data streams
description: index lifecycle management (ILM) automates the handling of index phases and data retention. You can check the current ILM policy applied to an index or...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-view-status
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Check the ILM status of Elasticsearch indices and data streams
index lifecycle management (ILM) automates the handling of index phases and data retention. You can check the current ILM policy applied to an index or data stream and see its lifecycle phase, actions, and other status details using Kibana or the ILM Explain API.
<tip>
  If you're investigating an ILM-related problem, refer to [Troubleshoot index and snapshot lifecycle management](https://www.elastic.co/docs/troubleshoot/elasticsearch/start-ilm) and [Fix index lifecycle management errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/index-lifecycle-management-errors) in the Elasticsearch chapter of the **Troubleshoot** section.
</tip>

<tab-set>
  <tab-item title="Kibana">
    **To view the current lifecycle status for one or more indices:**
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Open the **Indices** tab.
    3. Enable **Include hidden indices** to view all indices, including those managed by ILM. If you're using data streams, you can find the data stream associated with any index listed in the **Data stream** column.
    4. Use the search tool to find the index you're looking for. You can also filter the results by lifecycle status and lifecycle phase.
    5. Select the index to view details.
    6. Open the **Index lifecycle** tab to view ILM details such as the current lifecycle phase, the ILM policy name, the current [index lifecycle action](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions), and other details.
       ![Index lifecycle status page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-ilm-status.png)

    <tip>
      Elasticsearch comes with many built-in ILM policies. For standard Observability or Security use cases, you will have two ILM policies configured automatically: `logs@lifecycle` for logs and `metrics@lifecycle` for metrics.To learn how to create and adjust copies of built-in ILM policies for managed data streams, such as those created when you install an Elastic Integration, refer to our tutorial [Customize built-in ILM policies in Elasticsearch](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-customize-built-in-policies).
    </tip>
    **To view the current lifecycle status for a datastream:**
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Open the **Data Streams** tab.
    3. Use the search tool to find the data stream you're looking for.
    4. Select the data stream to view details. The flyout that opens includes direct links to the ILM policy and the index template.
       ![Data stream status page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-datastream-status.png)
    **To view the current lifecycle status for a datastream on the Streams page:** <applies-to>Elastic Stack: Generally available since 9.2, Elastic Stack: Preview in 9.1</applies-to>Starting with Elastic Stack version 9.2, the [**Streams**](https://www.elastic.co/docs/solutions/observability/streams/streams) page provides a centralized interface for common data management tasks in Kibana.
    1. Go to the **Streams** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. A stream maps directly to an Elasticsearch data stream. Select a stream to view its details.
    3. Go to the **Retention** tab to see how long your stream retains data and to get insight into your stream's data ingestion and storage size. A stream can retain the data indefinitely, for a custom period, or by following an existing ILM policy. For more information, refer to [Manage data retention for Streams](https://www.elastic.co/docs/solutions/observability/streams/management/retention).
  </tab-item>

  <tab-item title="API">
    Use the [Explain the lifecycle state API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-explain-lifecycle) to view the current lifecycle status for an index:
    ```json
    ```
    Tthe API response shows the current ILM phase and other details:
    ```json
    {
      "indices": {
        ".ds-metrics-system.process-default-2025.06.04-000001": {
          "index": ".ds-metrics-system.process-default-2025.06.04-000001",
          "managed": true,
          "policy": "metrics",
          "index_creation_date_millis": 1749060710358,
          "time_since_index_creation": "22.91d",
          "lifecycle_date_millis": 1749060710358,
          "age": "22.91d",
          "phase": "hot",
          "phase_time_millis": 1749060711038,
          "action": "rollover",
          "action_time_millis": 1749060712038,
          "step": "check-rollover-ready",
          "step_time_millis": 1749060712038,
          "phase_execution": {
            "policy": "metrics",
            "phase_definition": {
              "min_age": "0ms",
              "actions": {
                "rollover": {
                  "max_age": "30d",
                  "max_primary_shard_docs": 200000000,
                  "min_docs": 1,
                  "max_primary_shard_size": "50gb"
                }
              }
            },
            "version": 1,
            "modified_date_in_millis": 1749059754363
          }
        }
      }
    }
    ```
    You can also call this API for a data stream:
    ```json
    ```
    When called for a data stream, the API retrieves the current lifecycle status for the stream's backing indices:
    ```json
    {
      "indices": {
        ".ds-metrics-system.process-default-2025.06.04-000001": {
          "index": ".ds-metrics-system.process-default-2025.06.04-000001",
          "managed": true,
          "policy": "metrics",
          "index_creation_date_millis": 1749060710358,
          "time_since_index_creation": "22.91d",
          "lifecycle_date_millis": 1749060710358,
          "age": "22.91d",
          "phase": "hot",
          "phase_time_millis": 1749060711038,
          "action": "rollover",
          "action_time_millis": 1749060712038,
          "step": "check-rollover-ready",
          "step_time_millis": 1749060712038,
          "phase_execution": {
            "policy": "metrics",
            "phase_definition": {
              "min_age": "0ms",
              "actions": {
                "rollover": {
                  "max_age": "30d",
                  "max_primary_shard_docs": 200000000,
                  "min_docs": 1,
                  "max_primary_shard_size": "50gb"
                }
              }
            },
            "version": 1,
            "modified_date_in_millis": 1749059754363
          }
        }
      }
    }
    ```
  </tab-item>
</tab-set>