﻿---
title: Apply an index lifecycle policy to an existing Elasticsearch index
description: While index templates are typically used to automatically apply index lifecycle management (ILM) policies to new indices, you might need to apply a policy...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-apply
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Apply an index lifecycle policy to an existing Elasticsearch index
While index templates are typically used to automatically apply index lifecycle management (ILM) policies to new indices, you might need to apply a policy to an existing index. This page explains how to manually assign an ILM policy to an index through Kibana or using the Elasticsearch API, ensuring your existing data is managed according to lifecycle rules. This is useful if you want to:
- Configure the indices to move through different [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) as they age.
- Perform [lifecycle actions](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions) such as downsampling or shrinking.
- Delete the indices when they reach a certain age.

<warning>
  Consider the following before manually applying a policy to an index:
  - If an index is currently managed by an ILM policy you must first remove that policy before applying a new one. To remove or make changes to an ILM policy currently applied to one or more indices, or to switch indices to use a different policy, refer to [Update or switch an Elasticsearch index lifecycle policy](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-updates).
  - Do not manually apply a policy that uses the rollover action. Policies that use rollover must be applied by the [index template](/docs/manage-data/lifecycle/index-lifecycle-management/configure-lifecycle-policy#apply-policy-template). Otherwise, the policy is not carried forward when the rollover action creates a new index. For an approach to migrating existing indices that supports rollover, refer to [Migrate to ILM](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/migrate-ilm).
</warning>

You can do this procedure in Kibana or using the Elasticsearch API.
<tab-set>
  <tab-item title="Kibana">
    To apply a lifecycle policy to an existing index:
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. In the **Indices** tab, search for and select an index. Enable **Include hidden indices** to see the full list of indices.
    3. From the **Manage index** dropdown menu select **Add lifecycle policy**.
    4. Choose a lifecycle policy and confirm your changes.
  </tab-item>

  <tab-item title="API">
    Use the [update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings) to apply a lifecycle policy to an index.
    ```json

    {
      "index": {
        "lifecycle": {
          "name": "my_ilm_policy"
        }
      }
    }
    ```
    You can apply the same policy to multiple indices by using wildcards in the index name when you call the API.
    ```json

    {
      "index": {
        "lifecycle": {
          "name": "my_ilm_policy"
        }
      }
    }
    ```

    <warning>
      Be careful not to inadvertently match indices that you don’t want to modify.
    </warning>
  </tab-item>
</tab-set>

Once the policy is applied, ILM starts managing the index immediately.