﻿---
title: Migrate to ILM
description: You may already be another mechanism to manage the lifecycle of your indices. To help you adapt your existing indices to use index lifecycle management,...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/migrate-ilm
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Migrate to ILM
You may already be another mechanism to manage the lifecycle of your indices. To help you adapt your existing indices to use index lifecycle management, a few guides are available:
<definitions>
  <definition term="Migrate to index lifecycle management (ILM) on Elastic Cloud Hosted or Elastic Cloud Enterprise deployments Elastic Cloud Hosted: Generally available Elastic Cloud Enterprise: Generally available">
    Describes how to migrate Elasticsearch indices in an Elastic Cloud Hosted or Elastic Cloud Enterprise deployment from using deprecated index curation or another periodic indices management mechanism to use index lifecycle management.
  </definition>
  <definition term="Migrate to ILM on self-managed and Elastic Cloud on Kubernetes deployments  Self-managed Elastic deployments: Generally available Elastic Cloud on Kubernetes: Generally available">
    Describes how to migrate Elasticsearch indices in a self-managed environment from using deprecated index curation, or any other lifecycle mechanism, to use index lifecycle management.
  </definition>
  <definition term="Migrate index allocation filters to ILM node roles Elastic Stack: Generally available">
    Describes how to migrate from using custom node attributes and attribute-based allocation filters to using built-in node roles, enabling ILM to automatically move indices between data tiers.
  </definition>
</definitions>

If you are configuring ILM for new indices, refer to [Create an index lifecycle management policy in Elasticsearch](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/configure-lifecycle-policy). If you plan to manually apply an index lifecycle management policy to existing indices that are not already using another type of lifecycle management, refer to [Apply an index lifecycle policy to an existing Elasticsearch index](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-apply).