﻿---
title: Managing lifecycle polices for integrations data
description: Learn to apply and manage lifecycle policies for integrations data stored in Elasticsearch. This documentation covers default policies for Elastic integrations,...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/manage-lifecycle-integrations-data
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Managing lifecycle polices for integrations data
Learn to apply and manage lifecycle policies for integrations data stored in Elasticsearch. This documentation covers default policies for Elastic integrations, how to override them, and how to align retention rules with your requirements.
An Elastic integration is a pre-packaged collection of assets that provides an effective, simplified way to monitor a product, system, or service, with minimal required setup. Most integrations rely on Elastic Agent as an ingest mechanism, and the policies used to govern installed integrations are managed in Fleet.
You can find installation and configuration details for all integrations in the [Elastic integrations](https://docs.elastic.co/en/integrations) chapter of the **Reference** section. To learn about managing your installed integrations, refer to [Manage Elastic Agent integrations](https://www.elastic.co/docs/reference/fleet/manage-integrations) in the Fleet and Elastic Agent chapter of the **Reference** section.
When you install an integration, an [index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) (ILM) policy is configured automatically to manage the integration's component [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams) and their backing indices. To view or adjust how your integration data is managed, a first step is to find the data streams that you're interested in. There are a few ways to do this:
<dropdown title="Find the data stream for a Kibana visualization">
  To find the data stream associated with a visualization in a Kibana:
  1. Open **Dashboards** from the Kibana menu and select a dashboard to view. For example, with the [System integration](https://www.elastic.co/docs/reference/integrations/system) installed, you can open the `[Metrics System] Host overview` dashboard to find visualizations about the host system being monitored.
  2. Hover over any visualization and click the **Explore in Discover** icon.
     ![Explore in discover](https://www.elastic.co/docs/manage-data/images/ilm-explore-in-discover.png)
  3. In **Discover**, the list of documents shows the columns for fields applicable to the visualzation that you selected. Select any document that has data for those fields and click the **Toggle dialog with details** icon.
     ![Discover documents list](https://www.elastic.co/docs/manage-data/images/ilm-toggle-document-details.png)
  4. In the document details, there are three `data_stream` fields. The full [data stream name](/docs/reference/fleet/data-streams#data-streams-naming-scheme) is a composite of `data_stream.type`, `data_stream.dataset` and `data_stream.namespace`, separated by a hyphen. For example, in the System integration, the **CPU usage over time** visualization is associated with the `metrics-system.cpu-default` data stream.
     You can also see the data stream's current backing index, as well as other information such as the document timestamp and details about the agent that ingested the data.
     ![Document details](https://www.elastic.co/docs/manage-data/images/ilm-document-data-stream.png)
</dropdown>

<dropdown title="Find the data streams for an integration">
  To find the data streams associated with an installed integration:
  1. In Kibana go to **Management > Integrations > Installed integrations** and select any integration.
  2. Open the **Assets** tab and expand the **Index templates** list.
     In the list, the name of each [index template](https://www.elastic.co/docs/manage-data/data-store/templates) matches an associated data stream. For example, the `metrics-system.cpu` template matches the `metrics-system.cpu-default` data stream that is set up when the System integration is installed.
     ![Integration assets](https://www.elastic.co/docs/manage-data/images/ilm-integration-assets.png)
</dropdown>

<dropdown title="Find the data streams managed in Fleet">
  To find all of the data streams that are managed in Fleet:
  1. In Kibana, go to the **Fleet** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
  2. Select the **Data streams** tab.
  3. Use the search field and dropdown menus to filter the list. You can filter by the data stream type, dataset, namespace, or by the integration that the data stream belongs to.
     ![Integration assets](https://www.elastic.co/docs/manage-data/images/ilm-fleet-data-streams.png)
</dropdown>

For any data stream that you're interested in, you can [view its current lifecycle status](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/policy-view-status), including details about its associated ILM policy.
After you've identified one or more data streams for which you'd like to customize how the data is managed over time, refer to our tutorials:
- For steps to customize an ILM policy for a data stream, try out the [Customize built-in ILM policies in Elasticsearch](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-customize-built-in-policies) tutorial in the data lifecycle documentation.
- For the steps to customize an ILM policy for a set of data streams, such as all logs or metrics data streams across all namespaces, across only a selected namespace, and others, check the set of tutorials in [Customize data retention policies](https://www.elastic.co/docs/reference/fleet/data-streams-ilm-tutorial) in the Fleet and Elastic Agent reference documentation.